<?php

namespace Nio\LaravelInstaller\Helpers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\Console\Output\BufferedOutput;

class EnvironmentManager
{
    /**
     * @var string
     */
    private $envPath;

    /**
     * @var string
     */
    private $envExamplePath;

    /**
     * Set the .env and .env.example paths.
     */
    public function __construct()
    {
        $this->envPath = base_path('.env');
        $this->envExamplePath = base_path('.env.example');
    }

    /**
     * Get the content of the .env file.
     *
     * @return string
     */
    public function getEnvContent()
    {
        if (!file_exists($this->envPath)) {
            if (file_exists($this->envExamplePath)) {
                copy($this->envExamplePath, $this->envPath);
            } else {
                touch($this->envPath);
            }
        }

        return file_get_contents($this->envPath);
    }

    /**
     * Get the the .env file path.
     *
     * @return string
     */
    public function getEnvPath()
    {
        return $this->envPath;
    }

    /**
     * Get the the .env.example file path.
     *
     * @return string
     */
    public function getEnvExamplePath()
    {
        return $this->envExamplePath;
    }

    public function checkIsEnvFileWritable()
    {
        return is_writable($this->getEnvPath());
    }

    /**
     * Save the edited content to the .env file.
     *
     * @param Request $input
     * @return string
     */
    public function saveFileClassic(Request $input)
    {
        $message = trans('installer_messages.environment.success');

        try {
            file_put_contents($this->envPath, $input->get('envConfig'));
        } catch (Exception $e) {
            $message = trans('installer_messages.environment.errors');
        }

        return $message;
    }

    /**
     * Save the form content to the .env file.
     *
     * @param Request $request
     * @return string
     */
    public function saveFileWizard(Request $request)
    {
        $results = trans('installer_messages.environment.success');

        $envFileData = $this->fileData($request);

        try {
            file_put_contents($this->envPath, $envFileData);
        } catch (Exception $e) {
            $results = trans('installer_messages.environment.errors');
        }

        return $results;
    }



    /**
     * Get content of the .env file.
     *
     * @param Request $request
     * @return string
     */
    public function fileData(Request $request)
    {
        $key = $this->getNewKey();
        $data = 'APP_NAME=' . '"' . $request->app_name . '"' . "\n" .
            'APP_ENV=production' . "\n" .
            'APP_KEY=base64:JiLUKRXEZytQJsVnVBVfVXc+ZrNxX5O0OfVaEWNw78M=' . "\n" .
            'APP_DEBUG=false' . "\n" .
            'APP_TIMEZONE=' . 'UTC' . "\n" .
            'APP_URL=' . $request->app_url . "\n" .
            'APP_LOCALE=' . 'en' . "\n" .
            'APP_FALLBACK_LOCALE=' . 'en' . "\n" .
            'APP_FAKER_LOCALE=' . 'en_US' . "\n\n" .
            'APP_MAINTENANCE_DRIVER=' . 'file' . "\n" .
            'APP_MAINTENANCE_STORE=' . 'database' . "\n\n" .
            'BCRYPT_ROUNDS=' . '12' . "\n\n" .
            'LOG_CHANNEL=' . 'stack' . "\n" .
            'LOG_STACK=' . 'single' . "\n" .
            'LOG_DEPRECATIONS_CHANNEL=' . 'null' . "\n" .
            'LOG_LEVEL=' . 'debug' . "\n\n" .
            'DB_CONNECTION=mysql' . "\n" .
            'DB_HOST=' . $request->database_hostname . "\n" .
            'DB_PORT=' . $request->database_port . "\n" .
            'DB_DATABASE=' . $request->database_name . "\n" .
            'DB_USERNAME=' . $request->database_username . "\n" .
            'DB_PASSWORD=' . $request->database_password . "\n\n" .
            'SESSION_DRIVER=file' . "\n" .
            'SESSION_LIFETIME=' . '120' . "\n" .
            'SESSION_ENCRYPT=' . 'false' . "\n" .
            'SESSION_PATH=' . '/' . "\n" .
            'SESSION_DOMAIN=' . 'null' . "\n\n" .
            'BROADCAST_CONNECTION=log' . "\n" .
            'FILESYSTEM_DISK=' . 'local' . "\n" .
            'QUEUE_CONNECTION=' . 'database' . "\n\n" .
            'CACHE_STORE=' . 'database' . "\n" .
            'CACHE_PREFIX=' . "\n\n" .
            'MEMCACHED_HOST=127.0.0.1' . "\n\n" .
            'REDIS_CLIENT=' . 'phpredis' . "\n" .
            'REDIS_HOST=127.0.0.1' . "\n" .
            'REDIS_PASSWORD=null' . "\n" .
            'REDIS_PORT=6379' . "\n\n" .
            'MAIL_MAILER=smtp' . "\n" .
            'MAIL_HOST=' . "\n" .
            'MAIL_PORT=' . '"' . '465' . '"' . "\n" .
            'MAIL_USERNAME=' . "\n" .
            'MAIL_PASSWORD=' . "\n" .
            'MAIL_ENCRYPTION=' . '"' . 'ssl' . '"' . "\n" .
            'MAIL_FROM_ADDRESS=' . "\n" .
            'MAIL_FROM_NAME=' . '"${APP_NAME}"' . "\n\n" .
            'AWS_ACCESS_KEY_ID=' . "\n" .
            'AWS_SECRET_ACCESS_KEY=' . "\n" .
            'AWS_DEFAULT_REGION=' . 'us-east-1' . "\n" .
            'AWS_BUCKET=' . "\n" .
            'AWS_USE_PATH_STYLE_ENDPOINT=' . 'false' . "\n\n" .
            'VITE_APP_NAME=' . '"${APP_NAME}"' . "\n\n";

        return $data;
    }
    /**
     * Generate a new Application Key
     *
     * @param Request $request
     * @return string
     */
    public function getNewKey()
    {
        $outputLog = new BufferedOutput();
        Artisan::call('key:generate', ["--show" => true], $outputLog);
        return $outputLog->fetch();
    }
}
