<?php

use App\Models\User;
use App\Models\Transaction;
use App\Models\UserInvestment;
use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

/*Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote')->hourly();*/

Schedule::call(function () {
    $list = UserInvestment::where('user_investment_status_id', 1)->where('remaining_days', '>', 0)->where('next_payment_date', '<=', now())->get();
    if ($list->count() > 0) {
        foreach ($list as $item) {
            //credit user
            $table = User::find($item->user_id);
            $table->withdraw_wallet = $table->withdraw_wallet + $item->investment->daily_income;
            $table->save();
            //transaction
            $table = new Transaction();
            $table->user_id = $item->user_id;
            $table->transaction_type_id = 8;
            $table->description = "Profit from {$item->investment->name}";
            $table->amount = $item->investment->daily_income;
            $table->save();
            //update user investment
            $table = $item;
            $table->roi = $table->roi + $item->investment->daily_income;
            if (($table->remaining_days - 1) < 1) {
                $table->user_investment_status_id = 2;
            } else {
                $table->next_payment_date = date('Y-m-d H:i:s', time() + 86400);
            }
            $table->remaining_days = $table->remaining_days - 1;
            $table->save();
        }
    }
})->everyMinute();
