<x-template>
    <x-slot:title>Withdrawals</x-slot:title>
    <div class='container'>
    @if (Auth::user()->user_role_id == 1)
        <!--<div class='card mb-3'>
            <div class='card-header'>Filter</div>
            <div class='card-body'>
                <form action='{{ route('filter', ['route' => Route::currentRouteName()]) }}' method="post">
                    @csrf
                    <div class='row'>
                        <div class='col-sm-3 mb-1'>
                            <select class='form-control' name='status'>
                                <option value=''>Select Status</option>
                                @foreach ($withdrawal_status_list as $item)
                                    <option value='{{ $item->id }}'>{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class='col-sm-3 mb-1'>
                            <input type='submit' name='filter' value='Filter' class='btn btn-primary'>
                        </div>
                    </div>
                </form>
            </div>
        </div>-->
    @endif

    @if ($list->count() < 1)
        <x-no-record />
    @else
        @if ($vfilter != '')
            <p>{!! $vfilter !!}</p>
        @endif

        {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
        @foreach ($list as $item)
            <div class='card mb-2'>
                <div class='card-body'>
                    <div class='table-responsive'>
                        <table class='table'>

                            @if (Auth::user()->user_role_id == 1)
                                <tr>
                                    <th>User</th>
                                    <td><a href='{{ route('user_view', ['id' => $item->user->id]) }}'>{{ $item->user->name }}</a></td>
                                </tr>
                            @endif
                            <tr>
                                <th>Amount</th>
                                <td>{{ config('settings.currency') . number_format($item->amount, 2) }}</td>
                            </tr>
                            <!--<tr>
                                <th>Network</th>
                                <td>{{ $item->network }}</td>
                            </tr>
                            <tr>
                                <th>Currency</th>
                                <td>{{ $item->currency }}</td>
                            </tr>-->
                            <tr>
                                <th>Address</th>
                                <td>{{ $item->address }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>{!! status('withdrawals', $item) !!}</td>
                            </tr>
                            <tr>
                                <th>Date</th>
                                <td>{{ date('jS M Y h:i:s a', strtotime($item->created_at)) }}</td>
                            </tr>
                            @if(Auth::user()->user_role_id == 1)
                            <tr>
                                <th>Action</th>
                                <td>
                                    @if ($item->withdrawal_status_id == 3)
                                        <div class='d-grid gap-2 d-sm-block'>
                                            <a href="{{ route('withdrawal_process', ['id' => $item->id]) }}"
                                                class='btn btn-info' onclick='return confirm_action()'>Process</a>
                                            <a href="{{ route('withdrawal_reject', ['id' => $item->id]) }}" class='btn btn-danger'
                                                onclick='return confirm_action()'>Reject</a>
                                        </div>
                                    @endif
                                </td>
                            </tr>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        @endforeach

        {{ $list->links() }}

    @endif
</div>
</x-template>
