<x-template>
    <x-slot:title>User Investments</x-slot:title>
    <div class='container'>
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <p align='center'><img src='{{ url('public/uploads/investment/' . $item->investment->pix) }}'
                                class='img-fluid rounded' width='150'></p>
                        <table class='table'>
                            <tr>
                                <th>Investment:</th>
                                <td>{{ $item->investment->name }}</td>
                            </tr>
                            <tr>
                                <th>Price:</th>
                                <td>{{ config('settings.currency') . number_format($item->investment->price) }}</td>
                            </tr>
                            <tr>
                                <th>Duration:</th>
                                <td>{{ $item->investment->duration }} days</td>
                            </tr>
                            <tr>
                                <th>Profit:</th>
                                <td>{{ config('settings.currency') . number_format($item->roi) }}</td>
                            </tr>
                            <tr>
                                <th>Days Remaining:</th>
                                <td>{{ $item->remaining_days }} days</td>
                            </tr>
                            <tr>
                                <th>Next Payment:</th>
                                <td>
                                    @if($item->user_investment_status_id == 1)
                                    {{ date('jS M Y h:i:s a', strtotime($item->next_payment_date)) }}
                                @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>{!! status('user_investments', $item) !!}</td>
                            </tr>
                            <tr>
                                <th>Investment Date:</th>
                                <td>{{ date('jS M Y h:i:s a', strtotime($item->created_at)) }}</td>
                            </tr>
                            @if(Auth::user()->user_role_id == 1)
                            <tr>
                                <th>User:</th>
                                <td><a href='{{ route('user_view', ['id' => $item->user_id]) }}'>{{ $item->user->name }}</a></td>
                            </tr>
                            @endif
                        </table>
                    </div>
                </div>'
            @endforeach
            {{ $list->links() }}
        @endif
    </div>
</x-template>
