<x-template>
    <x-slot:title>View User</x-slot:title>
<div class='container'>
    <div class="card">
        <div class='card-body'>
            <form action='{{ route('transfer_fund') }}' method='post'>
                @csrf
                <input type='hidden' name='id' value='{{ $info->id }}'>
                <div class='row'>
                    <label>Transfer Funds</label>
                    <div class='col-sm-4 mb-2'>
                        <input type='number' step='any' name='amount' class='form-control' required placeholder="Amount">
                        </div>
                        <div class='col-sm-3 mb-2'>
<input type='submit' name='transfer' class='btn btn-primary' value='Transfer'>
                        </div>
                </div>
            </form>
            <div class='table-responsive'>
                <table class='table table-striped'>
                    <tr>
                        <th>#</th>
                        <td>{{ $info->id }}</td>
                    </tr>
                    <tr>
                        <th>Name</th>
                        <td>{{ $info->name }}</td>
                    </tr>
                    <tr>
                        <th>Email</th>
                        <td>{{ $info->email }}</td>
                    </tr>
                    <tr>
                        <th>Username</th>
                        <td>{{ $info->username }}</td>
                    </tr>
                    <tr>
                        <th>Ref</th>
                        <td>
                            @if($info->ref_id != '')
                            <a href='{{ route('user_view', ['id' => $info->ref_id]) }}'>{{ $info->ref->name }}</a>
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <th>Wallet</th>
                        <td>{{ config('settings.currency').number_format($info->wallet) }}</td>
                    </tr>
                    <tr>
                        <th>Withdraw Wallet</th>
                        <td>{{ config('settings.currency').number_format($info->withdraw_wallet) }}</td>
                    </tr>
                    <tr>
                        <th>Date</th>
                        <td>{{ $info->created_at }}</td>
                    </tr>
                    <tr>
                        <th>Role</th>
                        <td>{{ $info->user_role->name }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

</x-template>
