<x-template>
    <x-slot:title>Pending Payments</x-slot:title>
    <div class='container'>
        @if (Auth::user()->user_role_id == 1)
            <div class='card mb-4'>
                <div class='card-header'>Filter</div>
                <div class='card-body'>
                    <form action='{{ route('filter', ['route' => Route::currentRouteName()]) }}' method='post'>
                        @csrf
                        <div class='row'>
                            <div class='col-sm-3 mb-1'>
                                <select name='status' class='form-control'>
                                    <option value=''>Select Status</option>
                                    @foreach ($pending_payment_status_list as $item)
                                        <option value='{{ $item->id }}'>{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class='col-sm-3 mb-1'>
                                <input type='submit' name='filter' value='Filter' class='btn btn-primary'>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        @endif
        @if ($vfilter != '')
            <p>{!! $vfilter !!}</p>
        @endif
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <table class='table'>
                            @if (Auth::user()->user_role_id == 1)
                                <tr>
                                    <th>User:</th>
                                    <td><a
                                            href='{{ route('user_view', ['id' => $item->user_id]) }}'>{{ $item->user->name }}</a>
                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <th>Amount:</th>
                                <td>{{ config('settings.currency') . number_format($item->amount) }}</td>
                            </tr>
                            <tr>
                                <th>Bank:</th>
                                <td>{{ $item->payment_bank->bank }}</td>
                            </tr>
                            <tr>
                                <th>Acc Name:</th>
                                <td>{{ $item->payment_bank->acc_name }}</td>
                            </tr>
                            <tr>
                                <th>Acc Number:</th>
                                <td>{{ $item->payment_bank->acc_number }}</td>
                            </tr>
                            <tr>
                                <th>Proof:</th>
                                <td><a href='{{ url('public/uploads/proof/' . $item->proof) }}'><i
                                            class='bi bi-eye-fill'></i></a></td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>{!! status('pending_payments', $item) !!}</td>
                            </tr>
                        </table>
                        <div class='d-grid gap-2 d-sm-block'>
                            @if(Auth::user()->user_role_id == 1 && $item->pending_payment_status_id == 3)
                            <a
                                    href='{{ route('pending_payment_process', ['id' => $item->id]) }}' class='btn btn-success'
                                    onclick="return confirm_action()">Process</a>
                            <a
                                    href='{{ route('pending_payment_reject', ['id' => $item->id]) }}' class='btn btn-danger'
                                    onclick="return confirm_action()">Reject</a>
@elseif(Auth::user()->user_role_id == 2 && $item->pending_payment_status_id == 3)
<a
                                    href='{{ route('pending_payment_delete', ['id' => $item->id]) }}' class='btn btn-danger'
                                    onclick="return confirm_action()"><i class='bi bi-trash'></i> Delete</a>
                            @endif
                        </div>
                    </div>
                </div>'
            @endforeach
            {{ $list->links() }}
        @endif
    </div>
</x-template>
