<x-log-template>
    <x-slot:title>Login</x-slot:title>
    <!-- Session Status -->
    <x-auth-session-status :status="session('status')" />
    <x-auth-errors :errors="$errors" />

    <!-- Register Form -->
    <div class="register-form mt-4">
        <h6 class="mb-3 text-center">Register to continue.</h6>
        <form method="POST" action="{{ route('register') }}">
            @csrf
            <div class="form-group">
                <input class="form-control" type="text" placeholder="Your Name*" name='name'
                    value='{{ old('name') }}' required>
            </div>
            <div class="form-group">
                <input class="form-control" type="text" placeholder="Username*" name='username'
                    value='{{ old('username') }}' required>
            </div>
            <div class="form-group">
                <input class="form-control" type="email" placeholder="Email*" name='email'
                    value='{{ old('email') }}' required>
            </div>
            <div class="form-group position-relative">
                <input class="form-control" type="password" placeholder="Enter Password*" name='password'
                    value="{{ old('password') }}" required>
            </div>
            <div class="form-group position-relative">
                <input class="form-control" type="password" placeholder="Confirm Password*"
                    name='password_confirmation' value="{{ old('password_confirmation') }}" required>
            </div>
            <div class="form-group">
                <input class="form-control" type="text" placeholder="Invitation Code" name='ref'
                   @if(session('ref') == '') value='{{ old('ref') }}' @else value='{{ session('ref') }}' @endif>
            </div>
            @if(config('settings.g_site_key') != '' && config('settings.g_secret_key') != '')
<div class='form-group'>
    <div class="g-recaptcha" data-sitekey="{{ config('settings.g_site_key') }}"></div>
</div>
            @endif
            <button class="btn btn-primary w-100" type="submit">Register</button>
        </form>
    </div>
    <!-- Login Meta -->
    <div class="login-meta-data text-center">
        <p class="mb-0">Already have an account? <a class="stretched-link" href="{{ route('login') }}">Login</a></p>
    </div>

</x-log-template>
