<?php

use App\Models\PendingPaymentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
Schema::create('pending_payment_statuses', function(Blueprint $table){
$table->id();
$table->string('name');
$table->timestamp('created_at')->nullable();
$table->timestamp('updated_at')->nullable();
});

PendingPaymentStatus::insert([
    ['name' => 'Processed'],
    ['name' => 'Rejected'],
    ['name' => 'Pending']
]);

        Schema::table('pending_payments', function(Blueprint $table){
$table->foreignId('payment_bank_id')->nullable()->constrained()->cascadeOnDelete()->cascadeOnUpdate();
$table->string('proof')->nullable();
$table->foreignId('pending_payment_status_id')->default(3)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pending_payments', function(Blueprint $table){
$table->dropForeign('pending_payments_payment_bank_id_foreign');
$table->dropColumn(['payment_bank_id','proof']);
        });
    }
};
