<?php

use App\Models\PaymentGateway;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_gateways', function(Blueprint $table){
            $table->id();
            $table->string('name');
            $table->string('sk')->nullable();
            $table->string('pk')->nullable();
            $table->string('currency')->nullable();
            $table->string('status')->default('Enabled')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
                    });
            
                    PaymentGateway::insert([
                        ['name' => 'Stripe', 'sk' => 'sk_test_51NQtShBLKqBfLjnnMlj6oTm5V6TGQW8x6y5M3maEmVTKe3T3mry0bnMTkPuNW4zCnfmv2XBcdzIaJlK7baV7nTRb00ocAZRH4N', 'pk' => 'whsec_27ee4ffaed739961dce1afcd81605336103689aebb8623de11b5b4a084ab5e1d', 'currency' => 'usd'],
                        ['name' => 'Paystack', 'sk' => 'sk_test_5191c6cedb19e41a2b9a941f4698bcb2c38be3cd', 'pk' => 'pk_test_e783a81f835865b02f1772fbed585925540de44b', 'currency' => 'NGN'],
                        ['name' => 'Razorpay', 'sk' => 'aLakNzy7Ekpnqzrycsew14dQ', 'pk' => 'rzp_test_DEW3N6CLwZB2Nm', 'currency' => 'INR']
                    ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
