<?php

use App\Models\UserInvestmentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_investment_statuses', function(Blueprint $table){
$table->id();
$table->string('name');
$table->timestamp('created_at')->nullable();
$table->timestamp('updated_at')->nullable();
        });

        UserInvestmentStatus::insert([
            ['name' => 'Active'],
            ['name' => 'Inactive']
        ]);

        Schema::create('user_investments', function(Blueprint $table){
$table->id();
$table->foreignId('user_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
$table->foreignId('investment_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
$table->double('roi')->default(0);
$table->foreignId('user_investment_status_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
$table->bigInteger('remaining_days');
$table->timestamp('next_payment_date')->nullable();
$table->timestamp('created_at')->nullable();
$table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
