<?php

use App\Models\User;
use App\Models\UserRole;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_roles', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        UserRole::insert([
            ['name' => 'Admin'],
            ['name' => 'User']
        ]);

        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('user_role_id')->default(2)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->double('wallet')->default(0);
            $table->double('withdraw_wallet')->default(0);
            $table->foreignId('ref_id')->nullable()->constrained('users', 'id')->nullOnDelete()->cascadeOnUpdate();
            $table->integer('bonus_given')->default(0);
            $table->string('username');
        });

        $table = new User();
        $table->name = 'Admin';
        $table->email = 'admin@admin.com';
        $table->email_verified_at = date('Y-m-d H:i:s', time());
        $table->password = Hash::make('admin');
        $table->user_role_id = 1;
        $table->username = 'admin';
        $table->save();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
