<?php
use App\Models\Setting;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->string('tell')->nullable();
            $table->string('currency')->default('$');
            $table->string('logo');
            $table->string('favicon');
            $table->string('demo')->default('meg-investment.onecrib.com');
            $table->string('home_banner')->nullable();
            $table->string('home_banner_title')->nullable();
            $table->string('home_banner_sub_title')->nullable();
            $table->string('g_site_key')->nullable();
            $table->string('g_secret_key')->nullable();
            $table->double('min_withdraw')->default(0);
            $table->string('whatsapp')->nullable();
            $table->double('referral_bonus')->default(0);
            $table->double('daily_bonus')->default(0);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        $table = new Setting();
        $table->name = 'Mega Investment';
        $table->email = 'info@invest.com';
        $table->address = '#1 Abed port road, Cuzzy Palace';
        $table->tell = '01222777888';
        $table->logo = 'logo.png';
        $table->favicon = 'favicon.png';
        $table->home_banner = 'b1.jpg';
        $table->home_banner_title = 'About Us';
        $table->home_banner_sub_title = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.';
        $table->save();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
