<?php

use App\Http\Middleware\Demo;
use App\Http\Middleware\Access;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'access' => Access::class,
            'demo' => Demo::class
        ]);
        
        $middleware->validateCsrfTokens(except: [
            'payment_gateway/stripe_verify_payment','payment_gateway/paystack_verify_payment','payment_gateway/razorpay_verify','payment_gateway/cryptomus_verify','payment_gateway/nowpayment_verify'
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
