<?php

namespace App;

use App\Models\PaymentGateway;
use GuzzleHttp\Client;

class NowPayments
{
    protected $client;
    protected $apiKey;
    protected $baseUrl;
    var $info;
    /**
     * Create a new class instance.
     */
    public function __construct()
    {
        //get info
        $info = PaymentGateway::find(4);
        $this->info = $info;

        $this->client = new Client();
        $this->apiKey = $info->sk;
        $this->baseUrl = env('NOWPAYMENTS_ENV') === 'live'
            ? 'https://api.nowpayments.io/v1'
            : 'https://api-sandbox.nowpayments.io/v1';
    }

    public function createPayment($amount, $orderId)
    {
        $response = $this->client->post("{$this->baseUrl}/invoice", [
            'headers' => [
                'x-api-key' => $this->apiKey,
                'Content-Type' => 'application/json',
            ],
            'json' => [
                'price_amount' => $amount,
                'price_currency' => 'usd',
                'order_id' => $orderId,
                'order_description' => 'Wallet Deposit',
                'ipn_callback_url' => route('nowpayment_verify'),
                'success_url' => route('payment_gateway_success'),
                'cancel_url' => route('payment_gateway_fail'),
            ],
            'verify' => false,
        ]);

        $paymentData = json_decode($response->getBody(), true);

        /*print_r($paymentData);
        exit;*/

        // Store payment data in your database (optional)
        // Redirect user to payment URL
        //return redirect($paymentData['pay_address']);
        return $paymentData;
    }

    public function payout($amount, $walletAddress, $token)
    {
        //echo $this->apiKey;
        //exit;
        // Initiate payout
        $response = $this->client->post("{$this->baseUrl}/payout", [
            'headers' => [
                'x-api-key' => $this->apiKey,
                'Content-Type' => 'application/json',
                'Authorization' => "Bearer ".$token
            ],
            'json' => [
                'amount' => $amount,
                'currency' => 'usdt',
                'address' => $walletAddress,
                "ipn_callback_url"=> "https://nowpayments.io"
            ],
            'verify' => false,
        ]);

        print_r($response);
        exit;

        $withdrawalData = json_decode($response->getBody(), true);
    }

    public function token()
    {
        $apiKey = $this->info->sk;
        $url = $this->baseUrl . "/auth";

        $headers = [
            "Content-Type: application/json",
            "x-api-key: $apiKey"
        ];

        $data = array(
            "email"=> 'bantonbox@gmail.com',
            "password"=> 'killerC3$'
          );
          $data_string = json_encode($data);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $response = curl_exec($ch);
        $response = json_decode($response);
$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);   //get status code
//echo curl_error($ch);
//echo $status_code;
        curl_close($ch);

return $response;

    }
}
