<?php

namespace App\Http\Controllers;

use App\Cryptomus;
use App\Models\User;
use App\Models\UserBank;
use App\Models\Withdrawal;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\WithdrawalStatus;
use App\NowPayments;
use Illuminate\Support\Facades\Auth;

class WithdrawalController extends Controller
{
    public function index($filter = '--')
    {
        $my_id = Auth::id();
        $ft = filter($filter);
        $and = $ft['and'];
        $vfilter = $ft['vfilter'];

        if(Auth::user()->user_role_id == 2)
        {
            $and = $and." and user_id = $my_id ";
        }
$withdrawal_status_list = WithdrawalStatus::all();
        $list = Withdrawal::whereRaw("id > 0 $and")->orderBy('created_at', 'desc')->paginate(20);
        return view('withdrawal.index', ['list' => $list, 'vfilter' => $vfilter, 'withdrawal_status_list' => $withdrawal_status_list]);

    }

    public function create()
    {
        $cryptomus = new Cryptomus();
        //$payment_method = $cryptomus->payment_method();
        return view('withdrawal.create');
    }
    public function store(Request $request)
    {
        $cryptomus = new Cryptomus();
        $request->validate([
            'amount' => 'numeric|required|min:1',
            'address' => 'required'
        ]);
        //check balance
        if ($request->input('amount') > Auth::user()->withdraw_wallet) {
            return redirect()->back()->withInput()->withErrors(["Insufficient wallet balance"]);
        }
        //min withdraw
        if($request->input('amount') < config('settings.min_withdraw'))
        {
            return redirect()->back()->withInput()->withErrors(["Minimum withdraw amount is: ".config('settings.currency').number_format(config('settings.min_withdraw'))]);
        }
        //check if bank is set
        /*$user_bank = UserBank::where('user_id', Auth::id())->count();
        if($user_bank < 1)
        {
            return redirect()->back()->withInput()->withErrors(["Kindly setup your banking info"]);
        }*/

        $order_id = ref();

        /*$net_arr = explode('|', $request->input('network'));

        $network = $net_arr[0];
        $currency = $net_arr[1];
        $min_amount = $net_arr[2];
        $max_amount = $net_arr[3];
        $fee_amount = $net_arr[4];
        $percent = $net_arr[5];

$pay = $cryptomus->payout($request->input('amount'), $currency, $network, $order_id, $request->input('address'));*/
/*print_r($pay);
exit;*/

/*$now_payment = new NowPayments();
$token = $now_payment->token()->token;

$payout = $now_payment->payout($request->input('amount'), $request->input('address'), $token);*/

            //debit user
            $table = User::find(Auth::id());
            $table->withdraw_wallet = $table->withdraw_wallet - $request->input('amount');
            $table->save();

            //transaction
            /*$table = new Transaction();
            $table->user_id = Auth::id();
            $table->transaction_type_id = 4;
            $table->description = "Withdraw to ".$request->input('address');
            $table->amount = $request->input('amount');
            $table->ref = $order_id;
            $table->channel = 'cryptomus';
            $table->save();*/

            //withdrawal
            $table = new Withdrawal();
            $table->user_id = Auth::id();
            $table->amount = $request->input('amount');
            $table->address = $request->input('address');
            $table->withdrawal_status_id = 3;
            $table->save();

            return redirect()->route('withdrawal')->with('status', 'Withdrawal processing');

    }

    public function process($id)
    {
        $info = Withdrawal::find($id);
            $ref = ref();

        $table = $info;
        $table->withdrawal_status_id = 1;
        $table->save();
        //transaction
        $table = new Transaction();
        $table->user_id = $info->user_id;
        $table->transaction_type_id = 4;
        $table->description = 'Funds transferred to ' . $info->user->name;
        $table->amount = $info->amount;
        $table->ref = $ref;
        $table->save();

        return redirect()->back()->with('status', 'Transfer successful');
    }

    public function reject($id)
    {
        $info = Withdrawal::find($id);

        $table = $info;
        $table->withdrawal_status_id = 2;
        $table->save();
        //return funds
        $table = $info->user;
        $table->withdraw_wallet = $table->withdraw_wallet + $info->amount;
        $table->save();

        return redirect()->back()->with('status', 'Withdrawal rejected');
    }
}
