<?php

namespace App\Http\Controllers;

use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Exports\ExportTransaction;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class TransactionController extends Controller
{
    public function index($filter = '--', $type = '--')
    {
        $fil = filter($filter);
        $and = $fil['and'];
        $vfilter = $fil['vfilter'];

        $user_id = Auth::id();

        if (Auth::user()->user_role_id == 2) {
            $and = $and . " and user_id = $user_id ";
        }

        $list = Transaction::whereRaw("id > 0 $and")->orderBy('created_at', 'desc')->paginate(20);

        if ($type == 'export') {
            return Excel::download(new ExportTransaction($list), 'transaction.xlsx');
        }
        return view('transaction.index', ['list' => $list, 'vfilter' => $vfilter, 'filter' => $filter]);
    }
}
