<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Symfony\Component\Mailer\Transport\Smtp\EsmtpTransport;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;

class SettingController extends Controller
{
    public function create()
    {
        return view('setting.create');
    }

    public function store(Request $request)
    {
        $table = Setting::find(1);
        $table->name = $request->input('name');
        $table->email = $request->input('email');
        $table->currency = $request->input('currency');
        $table->tell = $request->input('tell');
        $table->address = $request->input('address');
        $table->home_banner_title = $request->input('home_banner_title');
        $table->home_banner_sub_title = $request->input('home_banner_sub_title');
        $table->min_withdraw = $request->input('min_withdraw');
        $table->whatsapp = $request->input('whatsapp');
        $table->referral_bonus = $request->input('referral_bonus');
        $table->daily_bonus = $request->input('daily_bonus');
        $table->telegram = $request->input('telegram');
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }

    public function testimony()
    {
        return view('setting.testimony');
    }

    public function testimony_store(Request $request)
    {
        $request->validate([
            'testimony_bonus' => 'required|numeric'
        ]);

        $table = Setting::find(1);
        $table->testimony_bonus = $request->input('testimony_bonus');
        $table->testimony_instruction = $request->input('testimony_instruction');
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }

    public function smtp()
    {
        return view('setting.smtp');
    }

    public function smtp_store(Request $request)
    {
        if ($request->has('save')) {
            $host = $request->input('host');
            // 587
            $port = $request->input('port');
            // my-username
            $username = $request->input('username');
            // my-app-password
            $password = $request->input('password');
            // TLS (or SSL)
            $encryption = $request->input('encryption');
            $tls = ($encryption == $request->input('encryption')) ? true : false;
            $transport = new EsmtpTransport($host, $port, $tls);
            $transport->setUsername($username);
            $transport->setPassword($password);

            try {
                $transport->start();
            } catch (\Exception $e) {
                return redirect()->back()->withErrors([$e->getMessage()]);
            }

            setEnv('MAIL_MAILER', $request->input('mailer'));
            setEnv('MAIL_HOST', $request->input('host'));
            setEnv('MAIL_PORT', $request->input('port'));
            setEnv('MAIL_USERNAME', $request->input('username'));
            setEnv('MAIL_PASSWORD', $request->input('password'));
            setEnv('MAIL_ENCRYPTION', $request->input('encryption'));
            setEnv('MAIL_FROM_ADDRESS', $request->input('from_address'));

            return redirect()->back()->with('status', 'Settings saved');
        }
    }

    public function icon_create()
    {
        $info = Setting::find(1);
        return view('setting.icon_create', ['info' => $info]);
    }

    public function icon_store(Request $request)
    {
        $info = Setting::find(1);

        $request->validate([
            'logo' => 'nullable|image',
            'favicon' => 'nullable|image',
        ]);

        $table = $info;
        if ($request->hasFile('logo')) {
            unlink('public/images/' . $info->logo);
            $logo = $request->file('logo')->store('', 'images');
            $manager = new ImageManager(
                new Driver()
            );

            // open an image file
            $img = $manager->read(public_path('images/' . $logo));
            //dd(is_writable(public_path('images/' . $logo)));
            $img->resize(200, 50);
            $img->save();
            $table->logo = $logo;
        }
        if ($request->hasFile('favicon')) {
            unlink('public/images/' . $info->favicon);
            $favicon = $request->file('favicon')->store('', 'images');
            $manager = new ImageManager(
                new Driver()
            );
            // open an image file
            $img = $manager->read(public_path('images/' . $favicon));
            $img->resize(32, 32);
            $img->save();
            $table->favicon = $favicon;
        }
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }

    public function captcha()
    {
        return view('setting.captcha');
    }

    public function captcha_store(Request $request)
    {
        $table = Setting::find(1);
        $table->g_site_key = $request->input('g_site_key');
        $table->g_secret_key = $request->input('g_secret_key');
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }

    public function about()
    {
        return view('setting.about');
    }
    public function about_store(Request $request)
    {
        $table = Setting::find(1);
        $table->about = $request->input('about');
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }
    public function rules()
    {
        return view('setting.rules');
    }
    public function rules_store(Request $request)
    {
        $table = Setting::find(1);
        $table->rules = $request->input('rules');
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }
    public function notice()
    {
        return view('setting.notice');
    }
    public function notice_store(Request $request)
    {
        $table = Setting::find(1);
        $table->notice = $request->input('notice');
        $table->save();

        return redirect()->back()->with('status', 'Settings saved');
    }
    
    
}
