<?php

namespace App\Http\Controllers;

use App\Models\PaymentAmount;
use Illuminate\Http\Request;

class PaymentAmountController extends Controller
{
    public function index()
    {
        $list = PaymentAmount::orderBy('amount')->get();
        return view('payment_amount.index', ['list' => $list]);
    }

    public function create($id = '--')
    {
        if ($id != '--') {
            $info = PaymentAmount::find($id);
        }

        return view('payment_amount.create', ['id' => $id, 'info' => @$info]);
    }

    public function store(Request $request)
    {
        if (!$request->has('id')) {
            $table = new PaymentAmount();
        } else {
            $table = PaymentAmount::find($request->input('id'));
        }
        $table->amount = $request->input('amount');
        $table->save();

        return redirect()->route('payment_amount')->with('status', 'Payment amount saved');
    }

    public function delete($id)
    {
        $info = PaymentAmount::find($id);
        $info->delete();

        return redirect()->route('payment_amount')->with('status', 'Payment amount deleted');
    }

}
