<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        if(config('settings.g_secret_key') != '' && config('settings.g_site_key') != '')
        {
        //captcha
        $captcha = @$_POST['g-recaptcha-response'];
        $captcha_verify = validate_captcha($captcha);
if($captcha_verify == false)
{
    return redirect()->back()->withInput()->withErrors(['Captcha failed']);
}
        }

        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:'.User::class],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'username' => ['required', 'unique:'.User::class]
        ]);

        if($request->input('ref') != '')
        {
            //check valid ref
            $check_ref = User::where('username', $request->input('ref'))->count();
            $ref_info = User::where('username', $request->input('ref'))->first();
            if($check_ref < 1)
            {
                return redirect()->back()->withInput()->withErrors(['Invalid invitation code. You can register without invitation code if you want']);
            }
        }

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        event(new Registered($user));

        $table = $user;
        $table->username = $request->input('username');
        if($request->input('ref') != '' && @$check_ref > 0)
        {
            $table->ref_id = $ref_info->id;
            $request->session()->forget('ref');
        }
        $table->save();

        Auth::login($user);

        return redirect(route('dashboard', absolute: false));
    }
}
