<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;
use App\Http\Requests\Auth\LoginRequest;
use App\Models\Transaction;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        $request->session()->regenerate();

        $today = date('Ymd', time());
        $my_date = date('Ymd', strtotime(Auth::user()->daily_bonus_date));
        if($today != $my_date)
        {
            if(config('settings.daily_bonus') > 0)
            {
                //update user
            $table = User::find(Auth::id());
            $table->withdraw_wallet = $table->withdraw_wallet + config('settings.daily_bonus');
            $table->daily_bonus_date = date('Y-m-d H:i:s', time());
            $table->save();
            //transaction
            $table = new Transaction();
            $table->user_id = Auth::id();
            $table->transaction_type_id = 5;
            $table->description = 'Daily bonus from system';
            $table->amount = config('settings.daily_bonus');
            $table->save();
            }
        }

        return redirect()->intended(route('dashboard', absolute: false));
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
