<x-template>
    <x-slot:title>Save Customer</x-slot:title>

    <table class='table_form' align='center'>
        <tr>
            <td>
            <form action='{{ route('user_store') }}' method='post'>
                @csrf
                <input type='hidden' name='user_id' value='{{ $id }}'>
                <div class='row'>
                    <div class='mb-3 col-12'>
                        <label>Name*</label>
                        <input type='text' name='name' class='form-control' required
                            value='{{ old('name') ?? @$info->name }}'>
                    </div>
                    <div class='mb-3 col-12'>
                        <label>Email*</label>
                        <input type='email' name='email' class='form-control' required
                            value='{{ old('email') ?? @$info->email }}'>
                    </div>
                    @if($id == '--')
                    <div class='mb-3 col-12'>
                        <label>Phone*</label>
                        <input type='text' name='tell' class='form-control' required
                            value='{{ old('tell') ?? @$info->tell }}'>
                    </div>
                    <div class='mb-3 col-12'>
                        <label>Address*</label>
                        <textarea name='address' required class='form-control'>{{ old('address') }}</textarea>
                    </div>
                    <div class="col-md-6 form-group">
                        <label>State</label>
                        <select name='state' class='form-control'
                            onChange="get_city(this.value, 'label')">
                            <option value=''
                                @if (old('state') == '') selected @endif>
                                Select State</option>
                            @if ($state_list->count() > 0)
                                @foreach ($state_list as $item)
                                    <option value='{{ $item->id }}'
                                        @if (old('state') == $item->id) selected @endif>
                                        {{ $item->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="col-md-6 form-group" id='city_div'>
                        <label>City</label>
                        <select name='city' class='form-control'>
                            <option value=''
                                @if (old('city') == '') selected @endif>
                                Select City</option>
                            @if ($city_list != '')
                                @if ($city_list->count() > 0)
                                    @foreach ($city_list as $item)
                                        <option value='{{ $item->id }}'
                                            @if (old('city') == $item->id) selected @endif>
                                            {{ $item->name }}</option>
                                    @endforeach
                                @endif
                            @endif
                        </select>
                    </div>
                    @endif

                </div>
                <input class='btn btn-primary' type='submit' value='Save' name='save'>
            </form>
            </td>
        </tr>
    </table>


</x-template>
