<x-template>
    <x-slot:title>Payment Gateway</x-slot:title>
    <div class='container'>
        @if ($list->count() < 1)
            <x-no-record />
        @else
            <small>{{ $list->count() }} records</small>
            
                    @foreach ($list as $item)
                    <div class='card mb-2'>
                        <div class='card-body'>
                        <div class='table-responsive'>
                            <table class='table'>
                                <tr>
                                    <th>Name</th>
                                    <td>{{ $item->name }}</td>
                                </tr>
                                <tr>
                                    <th>Webhook</th>
                                    <td>
                                        @if ($item->id == 1)
                                            {!! wordwrap(route('stripe_verify_payment'), 20, "<br />", true) !!}
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td>{!! status('payment_gateways', $item) !!}</td>
                                </tr>
                                <tr>
                                    <th>Action</th>
                                    <td>
                                        <div class='d-grid gap-2 d-sm-block'>

                                            <a href='#' class='btn btn-warning btn-sm mb-1' data-bs-toggle="modal"
                                                data-bs-target="#gateway_modal{{ $item->id }}"><i class='bi bi-pen'></i>
                                                Edit</a>

                                            @if ($item->status == 'Disabled')
                                                <a href='{{ route('payment_gateway_enable', ['id' => $item->id]) }}'
                                                    class='btn btn-success btn-sm mb-1'>Enable</a>
                                            @elseif($item->status == 'Enabled')
                                                <a href='{{ route('payment_gateway_disable', ['id' => $item->id]) }}'
                                                    class='btn btn-danger btn-sm mb-1'>Disable</a>
                                            @endif
                                            <!-- Modal -->
                                            <div class="modal fade" id="gateway_modal{{ $item->id }}" tabindex="-1"
                                                aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <form action='{{ route('payment_gateway_store') }}'
                                                            method='post'>
                                                            @csrf
                                                            <input type='hidden' name='id'
                                                                value='{{ $item->id }}'>
                                                            <div class="modal-header">
                                                                <h1 class="modal-title fs-5" id="exampleModalLabel">Edit
                                                                    Gateway</h1>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class='mb-3'>
                                                                    @if($item->id == 4)
<label>API Key</label>
                                                                    @else
                                                                    <label>Secret Key</label>
                                                                    @endif
                                                                    
                                                                    <input type='text' name='sk'
                                                                        class='form-control'
                                                                        value='{{ $item->sk }}'>
                                                                </div>
@if($item->id != 4)
                                                                <div class='mb-3'>
                                                                    @if ($item->id == 1)
                                                                        <label>Webhook Secret</label>
                                                                    @elseif($item->id == 3)
                                                                        <label>Key ID</label>
                                                                    @else
                                                                        <label>Public Key</label>
                                                                    @endif
                                                                    <input type='text' name='pk'
                                                                        class='form-control'
                                                                        value='{{ $item->pk }}'>
                                                                </div>

                                                                <div class='mb-3'>
                                                                    <label>Currency</label>
                                                                    <input type='text' name='currency'
                                                                        value='{{ $item->currency }}'
                                                                        class='form-control'>
                                                                </div>
@endif
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary"
                                                                    data-dismiss="modal">Close</button>
                                                                <button type="submit" class="btn btn-primary">Save
                                                                    changes</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                </div>
            </div>
        @endforeach


        @endif
    </div>
</x-template>
