<x-template>
    <x-slot:title>User Section</x-slot:title>

    <div class="pt-3"></div>
    <div class="container direction-rtl">
        <div class="card mb-4">
            <div class="card-body">
                <div class="row g-3">

                    <div class="col-4">
                        <div class="feature-card mx-auto text-center">
                            <div class="card mx-auto bg-primary p-5">
                                <a href='{{ route('user_investment') }}' class='link-light'>
                                    <i class='bi bi-piggy-bank'></i><br />
                                    <small>Investments</small>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="feature-card mx-auto text-center">
                            <div class="card mx-auto bg-primary p-5">
                                <a href='{{ route('transaction') }}' class='link-light'>
                                    <i class='bi bi-flag'></i><br />
                                    <small>Transaction</small>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="feature-card mx-auto text-center">
                            <div class="card mx-auto bg-primary p-5">
                                <a href='{{ route('profile.edit') }}' class='link-light'>
                                    <i class='bi bi-person'></i><br />
                                    <small>Profile</small>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <h6>Latest Transactions</h6>
        @if ($transaction_list->count() < 1)
            <x-no-record />
        @else
            @foreach ($transaction_list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <div class='table-responsive'>
                            <table class='table'>
                                <tr>
                                    <th>Amount:</th>
                                    <td>{{ config('settings.currency').number_format($item->amount) }}</td>
                                </tr>
                                <tr>
                                    <th>Type:</th>
                                    <td>{{ $item->transaction_type->name }}</td>
                                </tr>
                                <tr>
                                    <th>Description:</th>
                                    <td>{{ $item->description }}</td>
                                </tr>
                                <tr>
                                    <th>Ref:</th>
                                    <td>{!! wordwrap($item->ref, 20, "<br />", 'true') !!}</td>
                                </tr>
                                <tr>
                                    <th>Channel:</th>
                                    <td>{{ $item->channel }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            @endforeach
            <div class='d-grid gap-2 d-block'>
            <a href='{{ route('transaction') }}' class='btn btn-primary'>View All</a>
        </div>
        @endif

    </div>

</x-template>
