<x-template>
    <x-slot:title>Users</x-slot:title>
    <div class='container'>
        <div class='card mb-5'>
            <div class='card-header'>Filter</div>
            <div class='card-body'>
                <form action='{{ route('filter', ['route' => Route::currentRouteName()]) }}' method='post'>
                    @csrf
                    <div class='row'>
                        <div class='col-sm-3 mb-2'>
                            <input type='text' name='search' placeholder="Search" class='form-control'>
                        </div>
                        <div class='col-sm-3 mb-2'>
                            <div class="input-group">
                                <input type="text" id="drange" class="form-control" name='drange'
                                    placeholder="Date Range" autocomplete="off">
                                <span class="input-group-text" id="basic-addon2"><i class="bi bi-calendar"></i></span>
                            </div>
                        </div>
                        <div class='col-sm-3 mb-2'>
                            <input type='submit' name='filter' class='btn btn-primary' value='Filter'>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        @if ($vfilter != '')
            <p><a class="btn btn-success mb-3" href="{{ route('user', ['filter' => $filter, 'type' => 'export']) }}"><i
                        class='bi bi-print'></i> Export</a></p>
            <p><small class='text-danger'>Filter:</small> {!! $vfilter !!}</p><br />
        @endif
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <div clss='table-responsive'>
                            <table class='table'>
                                <tr>
                                    <th>Name</th>
                                    <td><a href='{{ route('user_view', ['id' => $item->id]) }}'>{{ $item->name }}</a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td>{{ $item->email }}</td>
                                </tr>
                                <tr>
                                    <th>Username</th>
                                    <td>{{ $item->username }}</td>
                                </tr>
                                <tr>
                                    <th>Ref</th>
                                    <td>
                                        @if($item->ref_id != '')
                                        <a href='{{ route('user_view', ['id' => $item->ref_id]) }}'>{{ $item->ref->name }}</a>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Date</th>
                                    <td>{{ $item->created_at }}</td>
                                </tr>
                                <tr>
                                    <th>Action</th>
                                    <td>
                                        <div class='d-grid gap-2 d-sm-block'>
                                          <a
                                                href='{{ route('user_delete', ['id' => $item->id]) }}'
                                                class='btn btn-danger btn-sm' onclick="return confirm_action()"><i
                                                    class='bi bi-trash'></i> Delete</a>
                                        </div>

                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            @endforeach

    </div><br />
    {{ $list->links() }}
    @endif
    </div>
</x-template>
