<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WinController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SlideController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\UserBankController;
use App\Http\Controllers\TestimonyController;
use App\Http\Controllers\InvestmentController;
use App\Http\Controllers\WithdrawalController;
use App\Http\Controllers\PaymentBankController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\PaymentAmountController;
use App\Http\Controllers\PaymentGatewayController;
use App\Http\Controllers\PendingPaymentController;
use App\Http\Controllers\UserInvestmentController;

//WelcomeController
Route::get('/megzy', [WelcomeController::class, 'megzy'])->name('megzy');
Route::get('/migrate', [WelcomeController::class, 'migrate'])->name('migrate');
Route::get('/', [WelcomeController::class, 'index'])->name('welcome');
Route::post('/filter/{route}/{ext?}', [WelcomeController::class, 'filter'])->name('filter');
Route::get('/notice', [WelcomeController::class, 'notice'])->name('notice');
Route::get('/support', [WelcomeController::class, 'support'])->middleware(['auth', 'access:2'])->name('support');
Route::get('/ref/{username}', [WelcomeController::class, 'ref'])->name('ref');

//UserController
Route::get('/dashboard', [UserController::class, 'dashboard'])->middleware(['auth'])->name('dashboard');
Route::get('/user/index/{filter?}/{type?}', [UserController::class, 'index'])->middleware(['auth', 'access:1'])->name('user');
Route::get('/user/view/{id}', [UserController::class, 'view'])->middleware(['auth', 'access:1'])->name('user_view');
Route::get('/user/delete/{id}', [UserController::class, 'delete'])->middleware(['auth', 'access:1', 'demo'])->name('user_delete');
Route::match(['get','post'],'/user/recharge', [UserController::class, 'recharge'])->middleware(['auth', 'access:2'])->name('recharge');
Route::match(['get','post'],'/user/recharge_confirm/{request}', [UserController::class, 'recharge_confirm'])->middleware(['auth', 'access:2'])->name('recharge_confirm');
Route::match(['get','post'],'/user/recharge_confirmation/{request}', [UserController::class, 'recharge_confirmation'])->middleware(['auth', 'access:2'])->name('recharge_confirmation');
Route::get('/user/referrals', [UserController::class, 'referrals'])->middleware(['auth','access:2'])->name('referrals');
Route::get('/user/referrals2', [UserController::class, 'referrals2'])->middleware(['auth','access:2'])->name('referrals2');
Route::get('/user/dashboard', [UserController::class, 'user_dashboard'])->middleware(['auth','access:2'])->name('user_dashboard');
Route::post('/user/transfer_fund', [UserController::class, 'transfer_fund'])->middleware(['auth', 'access:1', 'demo'])->name('transfer_fund');

//UserBankController
Route::get('/user_bank/create', [UserBankController::class, 'create'])->middleware(['auth','access:2'])->name('user_bank_create');
Route::post('/user_bank/store', [UserBankController::class, 'store'])->middleware(['auth','access:2', 'demo'])->name('user_bank_store');

//InvestmentController
Route::get('/investment/index/{filter?}', [InvestmentController::class, 'index'])->middleware(['auth'])->name('investment');
Route::get('/investment/create/{id?}', [InvestmentController::class, 'create'])->middleware(['auth','access:1'])->name('investment_create');
Route::post('/investment/store', [InvestmentController::class, 'store'])->middleware(['auth','access:1', 'demo'])->name('investment_store');
Route::get('/investment/delete/{id}', [InvestmentController::class, 'delete'])->middleware(['auth','access:1', 'demo'])->name('investment_delete');
Route::get('/investment/buy/{id}', [InvestmentController::class, 'buy'])->middleware(['auth','access:2', 'demo'])->name('investment_buy');

//PaymentAmountController
Route::get('/payment_amount/index', [PaymentAmountController::class, 'index'])->middleware(['auth','access:1'])->name('payment_amount');
Route::get('/payment_amount/create/{id?}', [PaymentAmountController::class, 'create'])->middleware(['auth','access:1'])->name('payment_amount_create');
Route::post('/payment_amount/store', [PaymentAmountController::class, 'store'])->middleware(['auth','access:1', 'demo'])->name('payment_amount_store');
Route::get('/payment_amount/delete/{id}', [PaymentAmountController::class, 'delete'])->middleware(['auth','access:1', 'demo'])->name('payment_amount_delete');

//UserInvestment
Route::get('/user_investment/index', [UserInvestmentController::class, 'index'])->middleware(['auth'])->name('user_investment');

//WithdrawalController
Route::get('/withdrawal/index/{filter?}', [WithdrawalController::class, 'index'])->middleware(['auth'])->name('withdrawal');
Route::get('/withdrawal/create', [WithdrawalController::class, 'create'])->middleware(['auth','access:2'])->name('withdrawal_create');
Route::post('/withdrawal/store', [WithdrawalController::class, 'store'])->middleware(['auth','access:2', 'demo'])->name('withdrawal_store');
Route::get('/withdrawal/process/{id}', [WithdrawalController::class, 'process'])->middleware(['auth','access:1', 'demo'])->name('withdrawal_process');
Route::get('/withdrawal/reject/{id}', [WithdrawalController::class, 'reject'])->middleware(['auth','access:1', 'demo'])->name('withdrawal_reject');

//SettingController
Route::get('/setting/create', [SettingController::class, 'create'])->middleware(['auth', 'access:1'])->name('setting_create');
Route::post('/setting/store', [SettingController::class, 'store'])->middleware(['auth', 'access:1', 'demo'])->name('setting_store');
Route::get('setting/icon_create', [SettingController::class, 'icon_create'])->middleware(['auth','access:1'])->name('setting_icon_create');
Route::post('setting/icon_store', [SettingController::class, 'icon_store'])->middleware(['auth','access:1', 'demo'])->name('setting_icon_store');
Route::get('/setting/smtp', [SettingController::class, 'smtp'])->middleware(['auth', 'access:1'])->name('smtp');
Route::post('/setting/smtp_store', [SettingController::class, 'smtp_store'])->middleware(['auth', 'access:1', 'demo'])->name('smtp_store');
Route::get('/setting/captcha', [SettingController::class, 'captcha'])->middleware(['auth', 'access:1'])->name('captcha');
Route::post('/setting/captcha_store', [SettingController::class, 'captcha_store'])->middleware(['auth', 'access:1', 'demo'])->name('captcha_store');
Route::get('/setting/about', [SettingController::class, 'about'])->middleware(['auth', 'access:1'])->name('setting_about');
Route::post('/setting/about_store', [SettingController::class, 'about_store'])->middleware(['auth', 'access:1', 'demo'])->name('setting_about_store');
Route::get('/setting/rules', [SettingController::class, 'rules'])->middleware(['auth', 'access:1'])->name('setting_rules');
Route::post('/setting/rules_store', [SettingController::class, 'rules_store'])->middleware(['auth', 'access:1', 'demo'])->name('setting_rules_store');
Route::get('/setting/notice', [SettingController::class, 'notice'])->middleware(['auth', 'access:1'])->name('setting_notice');
Route::post('/setting/notice_store', [SettingController::class, 'notice_store'])->middleware(['auth', 'access:1', 'demo'])->name('setting_notice_store');
Route::get('/setting/testimony', [SettingController::class, 'testimony'])->middleware(['auth', 'access:1'])->name('setting_testimony');
Route::post('/setting/testimony_store', [SettingController::class, 'testimony_store'])->middleware(['auth', 'access:1', 'demo'])->name('setting_testimony_store');

//SlideController
Route::get('/slide/index', [SlideController::class, 'index'])->middleware(['auth', 'access:1'])->name('slide');
Route::get('/slide/create/{id?}', [SlideController::class, 'create'])->middleware(['auth', 'access:1'])->name('slide_create');
Route::post('/slide/store', [SlideController::class, 'store'])->middleware(['auth', 'access:1', 'demo'])->name('slide_store');
Route::get('/slide/delete/{id}', [SlideController::class, 'delete'])->middleware(['auth', 'access:1', 'demo'])->name('slide_delete');

//PaymentController
Route::get('payment_gateway/index', [PaymentGatewayController::class, 'index'])->middleware(['auth','access:1'])->name('payment_gateway');
Route::post('payment_gateway/store', [PaymentGatewayController::class, 'store'])->middleware(['auth','access:1', 'demo'])->name('payment_gateway_store');
Route::get('payment_gateway/enable/{id}', [PaymentGatewayController::class, 'enable'])->middleware(['auth','access:1', 'demo'])->name('payment_gateway_enable');
Route::get('payment_gateway/disable/{id}', [PaymentGatewayController::class, 'disable'])->middleware(['auth','access:1', 'demo'])->name('payment_gateway_disable');
Route::get('payment_gateway/success', [PaymentGatewayController::class, 'success'])->name('payment_gateway_success');
Route::get('payment_gateway/fail', [PaymentGatewayController::class, 'fail'])->name('payment_gateway_fail');
Route::get('payment_gateway/stripe_pay/{pay_amount}', [PaymentGatewayController::class, 'stripe_pay'])->name('stripe_pay');
Route::post('payment_gateway/stripe_verify_payment', [PaymentGatewayController::class, 'stripe_verify_payment'])->middleware(['demo'])->name('stripe_verify_payment');
Route::post('payment_gateway/paystack_verify_payment', [PaymentGatewayController::class, 'paystack_verify_payment'])->middleware(['demo'])->name('paystack_verify_payment');
Route::get('payment_gateway/razorpay_pay', [PaymentGatewayController::class, 'razorpay_pay'])->name('razorpay_pay');
Route::match(['get','post'], 'payment_gateway/razorpay_verify', [PaymentGatewayController::class, 'razorpay_verify'])->middleware(['demo'])->name('razorpay_verify');
Route::match(['get','post'], 'payment_gateway/cryptomus_verify', [PaymentGatewayController::class, 'cryptomus_verify'])->middleware(['demo'])->name('cryptomus_verify');
Route::match(['get','post'], 'payment_gateway/cryptomus_payout_verify', [PaymentGatewayController::class, 'cryptomus_payout_verify'])->middleware(['demo'])->name('cryptomus_payout_verify');
Route::match(['get','post'], 'payment_gateway/nowpayment_verify', [PaymentGatewayController::class, 'nowpayment_verify'])->middleware(['demo'])->name('nowpayment_verify');

//TransactionController
Route::get('/transaction/index/{filter?}/{type?}', [TransactionController::class, 'index'])->middleware(['auth', 'access:1|2'])->name('transaction');

//PaymentBankController
Route::get('/payment_bank/index', [PaymentBankController::class, 'index'])->middleware(['auth','access:1'])->name('payment_bank');
Route::get('/payment_bank/create/{id?}', [PaymentBankController::class, 'create'])->middleware(['auth','access:1'])->name('payment_bank_create');
Route::post('/payment_bank/store', [PaymentBankController::class, 'store'])->middleware(['auth','access:1', 'demo'])->name('payment_bank_store');
Route::get('/payment_bank/delete/{id}', [PaymentBankController::class, 'delete'])->middleware(['auth','access:1', 'demo'])->name('payment_bank_delete');

//PendingPaymentController
Route::get('/pending_payment/index/{filter?}', [PendingPaymentController::class, 'index'])->middleware(['auth'])->name('pending_payment');
Route::get('/pending_payment/create/{pay_amount}', [PendingPaymentController::class, 'create'])->middleware(['auth','access:2'])->name('pending_payment_create');
Route::post('/pending_payment/store', [PendingPaymentController::class, 'store'])->middleware(['auth','access:2', 'demo'])->name('pending_payment_store');
Route::get('/pending_payment/delete/{id}', [PendingPaymentController::class, 'delete'])->middleware(['auth','access:2', 'demo'])->name('pending_payment_delete');
Route::get('/pending_payment/process/{id}', [PendingPaymentController::class, 'process'])->middleware(['auth','access:1', 'demo'])->name('pending_payment_process');
Route::get('/pending_payment/reject/{id}', [PendingPaymentController::class, 'reject'])->middleware(['auth','access:1', 'demo'])->name('pending_payment_reject');

//TestimonyController
Route::get('/testimony/index/{type?}/{filter?}', [TestimonyController::class, 'index'])->middleware(['auth','access:1|2'])->name('testimony');
Route::get('/testimony/create', [TestimonyController::class, 'create'])->middleware(['auth','access:2'])->name('testimony_create');
Route::post('/testimony/store', [TestimonyController::class, 'store'])->middleware(['auth','access:2'])->name('testimony_store');
Route::get('/testimony/approve/{id}', [TestimonyController::class, 'approve'])->middleware(['auth','access:1'])->name('testimony_approve');
Route::get('/testimony/disapprove/{id}', [TestimonyController::class, 'disapprove'])->middleware(['auth','access:1'])->name('testimony_disapprove');

//WinController
Route::get('/win/index', [WinController::class, 'index'])->middleware(['auth','access:1|2'])->name('win');
Route::get('/win/create', [WinController::class, 'create'])->middleware(['auth','access:2'])->name('win_create');
Route::post('/win/store', [WinController::class, 'store'])->middleware(['auth','access:2'])->name('win_store');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->middleware(['demo'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->middleware(['demo'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
