<x-template>
    <x-slot:title>Promo Challenge</x-slot:title>
    <div class='container'>

        @if (Auth::user()->user_role_id == 2)
            <p><a href='{{ route('win_create') }}' class='btn btn-success'><i class="bi bi-plus"></i> Add</a></p>
        @endif

        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <table class='table'>
                            @if (Auth::user()->user_role_id == 1)
                                <tr>
                                    <th>User:</th>
                                    <td><a
                                            href='{{ route('user_view', ['id' => $item->user_id]) }}'>{{ $item->user->name }}</a>
                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <th>Facebook:</th>
                                <td><a href='{{ $item->facebook }}' target='_blank'>{{ $item->facebook }}</a></td>
                            </tr>
                            <tr>
                                <th>Instagram:</th>
                                <td><a href='{{ $item->instagram }}' target='_blank'>{{ $item->instagram }}</a></td>
                            </tr>
                            <tr>
                                <th>TikTok:</th>
                                <td><a href='{{ $item->tiktok }}' target='_blank'>{{ $item->tiktok }}</a></td>
                            </tr>
                            <tr>
                                <th>Twitter:</th>
                                <td><a href='{{ $item->twitter }}' target='_blank'>{{ $item->twitter }}</a></td>
                            </tr>
                            <tr>
                                <th>Others:</th>
                                <td><a href='{{ $item->others }}' target='_blank'>{{ $item->others }}</a></td>
                            </tr>
                            <tr>
                                <th>Date:</th>
                                <td>{{ date('jS M Y', strtotime($item->created_at)) }}</td>
                            </tr>
                        </table>
                    </div>
                </div>'
            @endforeach
            {{ $list->links() }}
        @endif
    </div>
</x-template>
