<x-template>
    <x-slot:title>Team</x-slot:title>
    <div class='container'>
        <div class="bg-white p-5 rounded shadow-lg mx-auto" style="max-width: 800px;">
            <h1 class="display-4 fw-bolder text-center text-white mb-4 p-2 rounded bg-info bg-opacity-10">
                MAKE MONEY WITH YARI TRADE
            </h1>

            <div class="mb-4 p-4 bg-success bg-opacity-10 rounded shadow-sm">
                <h2 class="h2 fw-bold text-white mb-3 text-center">
                    INVITE A FRIEND AND MAKE MONEY
                </h2>
                <p class="fs-5 mb-3 text-center text-white">
                    You will get paid <span class="fw-bolder text-white fs-4">5% commission</span> for every product your friend purchases.
                </p>
                <p class="text-white fst-italic text-center">
                    There are no limits to this.
                </p>
                <p class="fs-5 fw-semibold text-white text-center mt-3">
                    The more your friends invest, the more rewards you will receive!
                </p>
            </div>

            <div class="mb-4 p-4 bg-custom-purple-light rounded shadow-sm">
                <h2 class="h3 fw-bold text-purple-700 mb-3 text-center">
                    Best way to refer friends and family:
                </h2>
                <ol class="list-group list-group-numbered fs-5">
                    <li class="list-group-item border-0 bg-transparent">
                        Copy your referral link and send it to your contacts via email, SMS, and WhatsApp.
                    </li>
                    <li class="list-group-item border-0 bg-transparent">
                        Click on any of the social media icons to share your link with them with an already customized message and your referral link.
                    </li>
                    <li class="list-group-item border-0 bg-transparent">
                        Once they click on the link, register, and invest, instantly your account will be credited with <span class="fw-bolder text-purple-600">5% commission</span>.
                    </li>
                </ol>
                <p class="fs-5 fw-semibold text-purple-800 text-center mt-4">
                    The more your friends invest, the more rewards you will receive!
                </p>
            </div>

            <div class="mb-4 p-4 bg-info bg-opacity-10 rounded shadow-sm">
                <h2 class="h3 fw-bold text-white mb-3 text-center">
                    SHARE AND EARN 5% COMMISSION
                </h2>
                <ul class="list-group list-group-flush mb-4 text-white">
                    <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent border-0 py-2 text-white">
                        Facebook <span class="badge bg-primary rounded-pill">Earn 5% Commission</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent border-0 py-2 text-white">
                        Instagram <span class="badge bg-primary rounded-pill">Earn 5% Commission</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent border-0 py-2 text-white">
                        Twitter <span class="badge bg-primary rounded-pill">Earn 5% Commission</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent border-0 py-2 text-white">
                        WhatsApp <span class="badge bg-primary rounded-pill">Earn 5% Commission</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent border-0 py-2 text-white">
                        Telegram <span class="badge bg-primary rounded-pill">Earn 5% Commission</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent border-0 py-2 text-white">
                        Email <span class="badge bg-primary rounded-pill">Earn 5% Commission</span>
                    </li>
                </ul>

                <h3 class="h4 fw-bold text-white mb-3 text-center">
                    Use the buttons below on any of the platforms and earn 5% commission
                </h3>
                <ol class="list-group list-group-numbered fs-5">
                    <li class="list-group-item border-0 bg-transparent text-white">
                        Click on the share button to share your link on any platform such as Facebook, Instagram, Twitter, Whatsapp, Telegram and Email.
                    </li>
                    <li class="list-group-item border-0 bg-transparent text-white">
                        Once they register via your link, make an investment, you will receive 5% commission of any amount they invest instantly.
                    </li>
                </ol>
            </div>
        </div>
        <br />
       <x-referral-box/>
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <div clss='table-responsive'>
                            <table class='table'>
                                <tr>
                                    <th>Name</th>
                                    <td>{{ $item->name }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td>{{ $item->email }}</td>
                                </tr>
                                <tr>
                                    <th>Username</th>
                                    <td>{{ $item->username }}</td>
                                </tr>
                                <tr>
                                    <th>Date</th>
                                    <td>{{ $item->created_at }}</td>
                                </tr>

                            </table>
                        </div>
                    </div>
                </div>
            @endforeach

    </div><br />
    {{ $list->links() }}
    @endif
    </div>
</x-template>
