<x-template>
    <x-slot:title>Transactions</x-slot:title>
<div class='container'>
    <div class='card mb-3 mt-3'>
        <div class='card-header'>Filter</div>
        <div class='card-body'>
            <form action='{{ route('filter', ['route' => Route::currentRouteName()]) }}' method='post'>
                @csrf
                <div class='row'>
                    <div class="col-sm-3 mb-2">
                        <div class="input-group">
                            <input type="text" id="drange" class="form-control" name='drange'
                                placeholder="Date Range" autocomplete="off">
                            <div class="input-group-text"><i
                                    class="glyphicon glyphicon-calendar bi bi-calendar bi bi-calendar"></i></div>
                        </div>
                    </div>

                    <div class='col-sm-3 mb-2'>
                        <input type='submit' name='filter' class='btn btn-info' value='Filter'>
                    </div>
                </div>
            </form>
        </div>
    </div>
    @if ($vfilter != '')
        <p><a href='{{ route('transaction', ['filter' => $filter, 'type' => 'export']) }}' class='btn btn-info'><i
                    class='bi bi-printer'></i> Export</a></p><br />
        <p class='mb-1'>{!! $vfilter !!}</p>
    @endif
    @if ($list->count() < 1)
        <x-no-record />
    @else
        {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
                @foreach ($list as $item)
                    <div class='card mb-2'>
                        <div class='card-body'>
                            <div class='table-responsive'>
                                <table class='table'>
                                    @if (Auth::user()->user_role_id == 1)
                                        <tr>
                                            <th>User</th>
                                            <td><a
                                                    href="{{ route('user_view', ['id' => $item->user_id]) }}">{{ $item->user->name }}</a>
                                            </td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>Type</th>
                                            <td>{{ $item->transaction_type->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Description</th>
                                            <td>{{ $item->description }}</td>
                                        </tr>
                                        <tr>
                                            <th>Amount</th>
                                            <td>{{ config('settings.currency') . number_format($item->amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Ref</th>
                                            <td>{!! wordwrap($item->ref, 15, '<br />', true) !!}</td>
                                        </tr>
                                        <tr>
                                            <th>Channel</th>
                                            <td>{{ $item->channel }}</td>
                                        </tr>
                                        <tr>
                                            <th>Date</th>
                                            <td>{{ date('jS M Y', strtotime($item->created_at)) }}</td>
                                        </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                @endforeach

        {{ $list->links() }}
    @endif
</div>
</x-template>
