<x-template>
    <x-slot:title>Testimonies</x-slot:title>
    <div class='container'>
        @if($type == 'pending')
<p><strong>Pending Testimonies</strong></p>
        @endif
        @if (Auth::user()->user_role_id == 2)
            <p><a href='{{ route('testimony_create') }}' class='btn btn-success'><i class="bi bi-plus"></i> Add</a></p>
        @endif
        @if (Auth::user()->user_role_id == 1 && $type == '--')
            <div class='card mb-4'>
                <div class='card-header'>Filter</div>
                <div class='card-body'>
                    <form action='{{ route('filter', ['route' => Route::currentRouteName(), 'ext' => $type]) }}'
                        method='post'>
                        @csrf
                        <div class='row'>
                            <div class='col-sm-3 mb-1'>
                                <select name='status' class='form-control'>
                                    <option value=''>Select Status</option>
                                    @foreach ($testimony_status_list as $item)
                                        <option value='{{ $item->id }}'>{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class='col-sm-3 mb-1'>
                                <input type='submit' name='filter' value='Filter' class='btn btn-primary'>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        @endif
        @if ($vfilter != '')
            <p>{!! $vfilter !!}</p>
        @endif
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <table class='table'>
                            @if (Auth::user()->user_role_id == 1)
                                <tr>
                                    <th>User:</th>
                                    <td><a
                                            href='{{ route('user_view', ['id' => $item->user_id]) }}'>{{ $item->user->name }}</a>
                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <th>URL:</th>
                                <td><a href='{{ $item->url }}' target='_blank'>{{ $item->url }}</a></td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>{!! status('testimonies', $item) !!}</td>
                            </tr>
                        </table>
                        <div class='d-grid gap-2 d-sm-block'>
                            @if (Auth::user()->user_role_id == 1 && $item->testimony_status_id == 3)
                                <a href='{{ route('testimony_approve', ['id' => $item->id]) }}'
                                    class='btn btn-success' onclick="return confirm_action()">Approve</a>
                                <a href='{{ route('testimony_disapprove', ['id' => $item->id]) }}'
                                    class='btn btn-danger' onclick="return confirm_action()">Disapprove</a>
                            @endif
                        </div>
                    </div>
                </div>'
            @endforeach
            {{ $list->links() }}
        @endif
    </div>
</x-template>
