<x-template>
    <x-slot:title>Save Testimony</x-slot:title>
    <div class='container'>
        <div class='card'>
            <div class='card-body'>
                @if(Auth::user()->testify == 0)
            <div class='alert alert-success'>
                You can not testify at the moment. Kindy make an investment to qualify for testimony bonuses.
            </div>
                @else
                @if (config('settings.testimony_instruction') != '')
                    <div class='alert alert-info'>
                        {{ nl2br(config('settings.testimony_instruction')) }}
                    </div>
                @endif

                <form action='{{ route('testimony_store') }}' method='post'>
                    @csrf
                    <div class='mb-3'>
                        <label>URL*</label>
                        <input type='text' name='url' class='form-control' placeholder="https://example.com"
                            value='{{ old('url') }}'>
                    </div>
                    <input type='submit' name='submit' value='Submit' class='btn btn-primary'>
                </form>
@endif
            </div>
        </div>
    </div>
</x-template>
