<x-template>
    <x-slot:title>General Settings</x-slot:title>
    <div class='container'>
        <div class='card'>
            <div class='card-body'>
                <form action="{{ route('setting_store') }}" method="post">
                    @csrf
                    <div class='row'>
                        <div class='col-sm-12 mb-2'>
                            <label>Site Name*</label>
                            <input type='text' name='name' required class='form-control'
                                value="{{ config('settings.name') }}">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Email*</label>
                            <input type='email' name='email' required class='form-control'
                                value="{{ config('settings.email') }}">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Phone</label>
                            <input type='text' name='tell' class='form-control'
                                value="{{ config('settings.tell') }}">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Address</label>
                            <textarea name='address' class='form-control'>{{ config('settings.address') }}</textarea>
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Currency</label>
                            <input type='text' name='currency' class='form-control' required
                                value="{{ config('settings.currency') }}">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Whatsapp support number(with country code)</label>
                            <input type='text' name='whatsapp' class='form-control'
                                value="{{ config('settings.whatsapp') }}" placeholder="2348037593242">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Telegram support link</label>
                            <input type='text' name='telegram' class='form-control'
                                value="{{ config('settings.telegram') }}" placeholder="https://tme.com">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Dashboard about section Title</label>
                            <input type='text' name='home_banner_title' class='form-control'
                                value="{{ config('settings.home_banner_title') }}">
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Dashboard about section Sub Title</label>
                            <textarea name='home_banner_sub_title' class='form-control'>{{ config('settings.home_banner_sub_title') }}</textarea>
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Minimum withdrawal amount*</label>
                            <input type='number' step='any' name='min_withdraw' class='form-control'
                                value="{{ config('settings.min_withdraw') }}" required>
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Referral bonus %*</label>
                            <input type='number' step='any' name='referral_bonus' class='form-control'
                                value="{{ config('settings.referral_bonus') }}" required>
                        </div>
                        <div class='col-sm-12 mb-2'>
                            <label>Daily Bonus Amount*</label>
                            <input type='number' step='any' name='daily_bonus' class='form-control'
                                value="{{ config('settings.daily_bonus') }}" required>
                        </div>
                        

                    </div>

                    <input type='submit' name='save' class='btn btn-primary' value='Save'>
                </form>
            </div>
        </div>
    </div>

</x-template>
