<x-template>
    <x-slot:title>Save Investment</x-slot:title>
    <div class='container'>
        <div class='card'>
            <div class='card-body'>
                <p>Pay <span class='lead text-danger'>{{ config('settings.currency') . number_format($pay_amount) }}</span>
                    to the following bank account and upload proof using the form below</p>

                <div class='table-responsive mb-2'>
                    <table class='table table-stripped'>
                        <tr>
                            <th>Bank:</th>
                            <td>{{ $payment_bank->bank }}</td>
                        </tr>
                        <tr>
                            <th>Acc Name:</th>
                            <td>{{ $payment_bank->acc_name }}</td>
                        </tr>
                        <tr>
                            <th>Acc Number:</th>
                            <td>{{ $payment_bank->bank }}</td>
                        </tr>
                    </table>
                </div>

                <div class='card'>
                    <div class='card-header bg-info text-white'>Upload Proof</div>
                    <div class='card-body'>
                        <p><small class='text-danger'>Kindly upload proof of payment</small></p>
                        <form action="{{ route('pending_payment_store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                                <input type='hidden' name='amount' value='{{ $pay_amount }}'>
                                <input type='hidden' name='payment_bank' value='{{ $payment_bank->id }}'>
                            <div class='mb-3'>
                                <label>Proof*</label>
                                <input type='file' name='proof' class='form-control'>
        
                            </div>
        
                            <input type='submit' name='upload' class='btn btn-primary' value='Upload'>
                        </form>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</x-template>
