<x-template>
    <x-slot:title>Banks</x-slot:title>
    <div class='container'>
            <p><a href='{{ route('payment_bank_create') }}' class='btn btn-success'><i class='bi bi-plus'></i> Add</a>
            </p>
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->count() }} records

                        @foreach($list as $item)
                        <div class='card mb-3'>
                            <div class='card-body'>
                                <div class='table-responsive'>
                                    <table class='table'>
                                        <tr>
                                            <th>Bank:</th>
                                            <td>{{ $item->bank }}</td>
                                        </tr>
                                        <tr>
                                            <th>Acc Name:</th>
                                            <td>{{ $item->acc_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Acc Number:</th>
                                            <td>{{ $item->acc_number }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class='d-grid gap-2 d-sm-block'>
                                    <a href='{{ route('payment_bank_create', ['id' => $item->id]) }}' class='btn btn-warning'><i class='bi bi-pencil'></i> Edit</a> <a href='{{ route('payment_bank_delete', ['id' => $item->id]) }}' class='btn btn-danger' onclick="return confirm_action()"><i class='bi bi-trash'></i> Delete</a>
                                </div>
                            </div>
                        </div>

                        @endforeach

        @endif
    </div>
</x-template>
