<x-template>
    <x-slot:title>Recharge Amount</x-slot:title>
    <div class='container'>
            <p><a href='{{ route('payment_amount_create') }}' class='btn btn-success'><i class='bi bi-plus'></i> Add</a>
            </p>
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->count() }} records
           <div class='card'>
            <div class='card-body'>
                <div class='table-responsive'>
                    <table class='table'>
                        <tr>
                            <th>Amount</th>
                            <th>Action</th>
                        </tr>
                        @foreach($list as $item)
<tr>
    <td>{{ config('settings.currency').number_format($item->amount) }}</td>
    <td>
        <div class='d-grid gap-2 d-sm-block'>
            <a href='{{ route('payment_amount_create', ['id' => $item->id]) }}' class='btn btn-warning'><i class='bi bi-pencil'></i> Edit</a> <a href='{{ route('payment_amount_delete', ['id' => $item->id]) }}' class='btn btn-danger' onclick="return confirm_action()"><i class='bi bi-trash'></i> Delete</a>
        </div>
    </td>
</tr>
                        @endforeach
                    </table>
                </div>
            </div>
           </div>
        @endif
    </div>
</x-template>
