<x-template>
    <x-slot:title>Investments</x-slot:title>
    <div class='container'>
        @if (Auth::user()->user_role_id == 1)
            <p><a href='{{ route('investment_create') }}' class='btn btn-success'><i class='bi bi-plus'></i> Add</a></p>

            <div class='card mb-4'>
                <div class='card-header'>Filter</div>
                <div class='card-body'>
                    <form action='{{ route('filter', ['route' => Route::currentRouteName()]) }}' method='post'>
                        @csrf
                        <div class='row'>
                            <div class='col-sm-3 mb-1'>
                                <input type='text' name='search' class='form-control' placeholder="Search">
                            </div>
                            <div class='col-sm-3 mb-1'>
                                <select name='status' class='form-control'>
                                    <option value=''>Select Status</option>
                                    @foreach ($investment_status_list as $item)
                                        <option value='{{ $item->id }}'>{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class='col-sm-3 mb-1'>
                                <input type='submit' name='filter' value='Filter' class='btn btn-primary'>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        @endif
        @if ($vfilter != '')
            <p>{!! $vfilter !!}</p>
        @endif
        @if ($list->count() < 1)
            <x-no-record />
        @else
            {{ $list->firstItem() . ' - ' . $list->lastItem() . ' of ' . $list->total() }}
            @foreach ($list as $item)
                <div class='card mb-2'>
                    <div class='card-body'>
                        <p align='center'><img src='{{ url('public/uploads/investment/' . $item->pix) }}'
                                class='img-fluid rounded' width='150'></p>
                        <table class='table'>
                            <tr>
                                <th>Name:</th>
                                <td>{{ $item->name }}</td>
                            </tr>
                            <tr>
                                <th>Price:</th>
                                <td>{{ config('settings.currency') . number_format($item->price) }}</td>
                            </tr>
                            <tr>
                                <th>Duration:</th>
                                <td>{{ $item->duration }} days</td>
                            </tr>
                            <tr>
                                <th>Daily Income:</th>
                                <td>{{ config('settings.currency') . number_format($item->daily_income) }}</td>
                            </tr>
                            <tr>
                                <th>Total Income:</th>
                                <td>{{ config('settings.currency') . number_format($item->daily_income * $item->duration) }}
                                </td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>{{ $item->investment_status->name }}</td>
                            </tr>
                            <tr>
                                <th>Investments Allowed:</th>
                                <td>{{ investment_allowed($item) }}</td>
                            </tr>
                        </table>
                        <div class='d-grid gap-2 d-sm-block'>
                            @if (Auth::user()->user_role_id == 2)
                                @if ($item->investment_status_id == 1)
                                    <a href='{{ route('investment_buy', ['id' => $item->id]) }}'
                                        class='btn btn-success' onclick="return confirm_action()"><i
                                            class='bi bi-cart'></i> Buy</a>
                                @elseif($item->investment_status_id == 3)
                                    <button type="button" class="btn btn-secondary" disabled>Sold Out</button>
                                @endif
                                <button class="btn btn-info" type="button" data-bs-toggle="modal"
                                    data-bs-target="#description_modal{{ $item->id }}"><i
                                        class='bi bi-info-circle'></i> Details</button>

                                <div class="modal fade" id="description_modal{{ $item->id }}" tabindex="-1"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h6 class="modal-title" id="exampleModalLabel">Details</h6>
                                                <button class="btn btn-close p-1 ms-auto" type="button"
                                                    data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                {!! $item->description !!}
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-sm btn-secondary" type="button"
                                                    data-bs-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @elseif(Auth::user()->user_role_id == 1)
                                <a href='{{ route('investment_create', ['id' => $item->id]) }}'
                                    class='btn btn-warning'><i class='bi bi-pencil'></i> Edit</a> <a
                                    href='{{ route('investment_delete', ['id' => $item->id]) }}' class='btn btn-danger'
                                    onclick="return confirm_action()"><i class='bi bi-trash'></i> Delete</a>
                            @endif
                        </div>
                    </div>
                </div>'
            @endforeach
            {{ $list->links() }}
        @endif
    </div>
</x-template>
