<x-template>
    <x-slot:title>Save Investment</x-slot:title>
    <div class='container'>
        <div class='card'>
            <div class='card-body'>
                <form action="{{ route('investment_store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @if ($id != '--')
                        <input type='hidden' name='id' value='{{ $id }}'>
                    @endif
                    <div class='mb-3'>
                        <label>Name*</label>
                        <input type='text' name='name' required class='form-control'
                            value='{{ old('name') ?? @$info->name }}'>
                    </div>
                    <div class='mb-3'>
                        <label>Price*</label>
                        <input type='number' step='any' name='price' required class='form-control'
                            value='{{ old('price') ?? @$info->price }}'>
                    </div>
                    <div class='mb-3'>
                        <label>Duration(in days)*</label>
                        <input type='number' name='duration' required class='form-control'
                            value='{{ old('duration') ?? @$info->duration }}'>
                    </div>
                    <div class='mb-3'>
                        <label>Daily Income*</label>
                        <input type='number' step='any' name='daily_income' required class='form-control'
                            value='{{ old('daily_income') ?? @$info->daily_income }}'>
                    </div>
                    <div class='mb-3'>
                        <label>Description</label>
                        <textarea class='form-control' name='description'>{{ old('description') ?? @$info->description }}</textarea>
                    </div>
                    <div class='mb-3'>
                        <label>Image*</label>
                        <input type='file' name='pix' class='form-control'>
                        <small>200x200px</small><br />
                        @if ($id != '--')
                            <img src='{{ url('public/uploads/investment/' . $info->pix) }}' class='img-fluid'>
                        @endif
                    </div>
                    <div class='mb-3'>
                        <label>Investment Allowed(Enter 0 for multiple investments)*</label>
                        <input type='number' name='investment_allowed' required class='form-control'
                            value='{{ old('investment_allowed') ?? (@$info->investment_allowed ?? 0) }}'>
                    </div>
                    <div class='mb-3'>
                        <label>Status*</label>
                        <select name='investment_status' class='form-control' required>
                            @foreach ($investment_status_list as $item)
                                <option value='{{ $item->id }}'
                                    @if (old('investment_status') == $item->id) selected @elseif(@$info->investment_status_id == $item->id) selected @endif>
                                    {{ $item->name }}</option>
                            @endforeach
                        </select>

                    </div>
                    <input type='submit' name='save' class='btn btn-primary' value='Save'>
                </form>
            </div>
        </div>
    </div>
</x-template>
