<?php
use App\Models\PendingPayment;
use App\Models\Withdrawal;
use App\Models\Testimony;

$pending_testimony_count = Testimony::where('testimony_status_id', 3)->count();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#0134d4">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <!-- The above 4 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <!-- Title -->
    <title>{{ $title }}</title>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com/">
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
        rel="stylesheet">
    <x-head-inc />
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="{{ url('public/template') }}/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/bootstrap-icons.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/tiny-slider.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/baguetteBox.min.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/rangeslider.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/vanilla-dataTables.min.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/apexcharts.css">
    <!-- Core Stylesheet -->
    <link rel="stylesheet" href="{{ url('public/template') }}/style.css">

</head>

<body>
    <!-- Preloader -->
    <div id="preloader">
        <div class="spinner-grow text-primary" role="status"><span class="visually-hidden">Loading...</span></div>
    </div>
    <!-- Internet Connection Status -->
    <!-- # This code for showing internet connection status -->
    <div class="internet-connection-status" id="internetStatus"></div>
    <!-- Header Area -->
    <div class="header-area" id="headerArea">
        <div class="container">
            <!-- # Paste your Header Content from here -->
            <!-- # Header Five Layout -->
            <!-- # Copy the code from here ... -->
            <!-- Header Content -->
            <div
                class="header-content header-style-five position-relative d-flex align-items-center justify-content-between">
                <!-- Logo Wrapper -->
                <div class="logo-wrapper"><a href="{{ route('dashboard') }}"><img
                            src="{{ url('public/images/' . config('settings.logo')) }}" alt=""></a></div>
                @if (Auth::user()->user_role_id == 1)
                    <!-- Navbar Toggler -->
                    <div class="navbar--toggler" id="affanNavbarToggler" data-bs-toggle="offcanvas"
                        data-bs-target="#affanOffcanvas" aria-controls="affanOffcanvas"><span
                            class="d-block"></span><span class="d-block"></span><span class="d-block"></span></div>
                @endif
            </div>
            <!-- # Header Five Layout End -->
        </div>
    </div>
    <!-- # Sidenav Left -->
    <!-- Offcanvas -->
    <div class="offcanvas offcanvas-start" id="affanOffcanvas" data-bs-scroll="true" tabindex="-1"
        aria-labelledby="affanOffcanvsLabel">
        <button class="btn-close btn-close-white text-reset" type="button" data-bs-dismiss="offcanvas"
            aria-label="Close"></button>
        <div class="offcanvas-body p-0">
            <!-- Side Nav Wrapper -->
            <div class="sidenav-wrapper">
                <!-- Sidenav Profile -->
                <div class="sidenav-profile bg-gradient">
                    <div class="sidenav-style1"></div>
                    <!-- User Thumbnail -->
                    <div class="user-profile"><img src="{{ url('public/images/avatar.jpg') }}" alt="">
                    </div>
                    <!-- User Info -->
                    <div class="user-info">
                        <h6 class="user-name mb-0">{{ Auth::user()->name }}</h6><span>{{ Auth::user()->name }}</span>
                    </div>
                </div>
                <!-- Sidenav Nav -->
                <ul class="sidenav-nav ps-0">
                    <li><a href="{{ route('dashboard') }}"><i class="bi bi-house-door"></i>Dashboard</a></li>
                    <li><a href="{{ route('investment') }}"><i class="bi bi-currency-exchange"></i>Investments</a></li>
                    <li><a href="{{ route('pending_payment') }}"><i class="bi bi-hourglass"></i>Pending Payments<span
                                class="badge bg-danger rounded-pill ms-2">{{ PendingPayment::where('pending_payment_status_id', 3)->where('type', 'bank')->count() }}</span></a>
                    </li>
                    <li><a href="{{ route('withdrawal') }}"><i class="bi bi-arrow-down-square"></i>Withdrawals<span
                                class="badge bg-danger rounded-pill ms-2">{{ Withdrawal::where('withdrawal_status_id', 3)->count() }}</span></a>
                    </li>
                    <li><a href="{{ route('transaction') }}"><i class="bi bi-flag"></i>Transaction</a></li>
                    <li><a href="{{ route('user_investment') }}"><i class="bi bi-piggy-bank"></i>User Investments</a>
                    </li>
                    <li><a href="{{ route('user') }}"><i class="bi bi-people"></i>Users</a></li>
                    <li><a href="{{ route('setting_notice') }}"><i class="bi bi-clipboard"></i>Notice</a></li>
                    <li><a href="#"><i class="bi bi-chat-dots"></i> Testimonies</a>
                        <ul>
                            <li><a href="{{ route('testimony') }}">List</a></li>
                            <li><a href="{{ route('testimony', ['type' => 'pending']) }}">Pending <span
                                class="badge bg-danger rounded-pill ms-2">{{ $pending_testimony_count }}</span></a></li>
                        </ul>
                    </li>
                    <li><a href="{{ route('win') }}"><i class="bi bi-award"></i>Promo Challenge</a></li>
                    <li><a href="#"><i class="bi bi-gear"></i>Settings</a>
                        <ul>
                            <li><a href="{{ route('setting_create') }}">General</a></li>
                            <li><a href="{{ route('setting_icon_create') }}">Logo/Favicon</a></li>
                            <li><a href="{{ route('payment_gateway') }}">Payment Gateways</a></li>
                            <li><a href="{{ route('payment_bank') }}">Banks</a></li>
                            <li><a href="{{ route('slide') }}">Slide</a></li>
                            <li><a href="{{ route('setting_testimony') }}">Testimony Settings</a></li>
                            <li><a href="{{ route('payment_amount') }}">Recharge Amounts</a></li>
                            <li><a href="{{ route('captcha') }}">Captcha</a></li>
                            <li><a href="{{ route('smtp') }}">SMTP</a></li>
                            <li><a href="{{ route('setting_about') }}">About Us</a></li>
                            <li><a href="{{ route('setting_rules') }}">Rules</a></li>
                        </ul>
                    </li>
                    <li><a href="{{ route('profile.edit') }}"><i class="bi bi-person"></i>Profile</a></li>
                    <li><a href="{{ route('logout') }}"><span class='text-danger'><i
                                    class="bi bi-box-arrow-right"></i>Logout</a></span></li>
                </ul>

                <!-- Copyright Info -->
                <div class="copyright-info">
                    <p>{{ date('Y', time()) }} &copy; {{ config('settings.name') }}</p>
                </div>
            </div>
        </div>
    </div>
    @if (Route::currentRouteName() != 'dashboard' || Auth::user()->user_role_id == 1)
        @php
            $div_class = 'py-3';
        @endphp
    @endif
    <div class="page-content-wrapper {{ @$div_class }}">
        @if (Route::currentRouteName() != 'dashboard' || Auth::user()->user_role_id == 1)
            <div class='container'>
                <h5>{{ $title }}</h5>
                <x-auth-session-status :status="session('status')" />
                <x-auth-errors :errors="$errors" />
            </div>
        @endif
        {{ $slot }}

        <div class="pb-3"></div>
    </div>
    @if (Auth::user()->user_role_id == 2)
        <!-- Footer Nav -->
        <div class="footer-nav-area" id="footerNav">
            <div class="container px-0">
                <!-- =================================== -->
                <!-- Paste your Footer Content from here -->
                <!-- =================================== -->

                <!-- Footer Content -->
                <div class="footer-nav position-relative">
                    <ul class="h-100 d-flex align-items-center justify-content-between ps-0">
                        <li><a href="{{ route('dashboard') }}">
                                <svg class="bi bi-house-door-fill" width="20" height="20" viewBox="0 0 16 16"
                                    fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.5 14.5v-3.505c0-.245.25-.495.5-.495h2c.25 0 .5.25.5.5v3.5a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.146-.354L13 5.793V2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1.293L8.354 1.146a.5.5 0 0 0-.708 0l-6 6A.5.5 0 0 0 1.5 7.5v7a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 .5-.5" />
                                </svg><span>Home</span></a></li>
                        <li><a href="{{ route('investment') }}">
                                <svg class="bi bi-backpack2-fill" width="20" height="20" viewBox="0 0 16 16"
                                    fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M5 13h6v-3h-1v.5a.5.5 0 0 1-1 0V10H5z" />
                                    <path
                                        d="M6 2v.341C3.67 3.165 2 5.388 2 8v1.191l-1.17.585A1.5 1.5 0 0 0 0 11.118V13.5A1.5 1.5 0 0 0 1.5 15h1c.456.607 1.182 1 2 1h7c.818 0 1.544-.393 2-1h1a1.5 1.5 0 0 0 1.5-1.5v-2.382a1.5 1.5 0 0 0-.83-1.342L14 9.191V8a6 6 0 0 0-4-5.659V2a2 2 0 1 0-4 0m2-1a1 1 0 0 1 1 1v.083a6 6 0 0 0-2 0V2a1 1 0 0 1 1-1m0 3a4 4 0 0 1 3.96 3.43.5.5 0 1 1-.99.14 3 3 0 0 0-5.94 0 .5.5 0 1 1-.99-.14A4 4 0 0 1 8 4M4.5 9h7a.5.5 0 0 1 .5.5v4a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-4a.5.5 0 0 1 .5-.5" />
                                </svg><span>Products</span></a></li>
                        <li><a href="{{ route('referrals') }}">
                                <svg class="bi bi-diagram-3-fill" xmlns="http://www.w3.org/2000/svg" width="20"
                                    height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M6 3.5A1.5 1.5 0 0 1 7.5 2h1A1.5 1.5 0 0 1 10 3.5v1A1.5 1.5 0 0 1 8.5 6v1H14a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 2 7h5.5V6A1.5 1.5 0 0 1 6 4.5zm-6 8A1.5 1.5 0 0 1 1.5 10h1A1.5 1.5 0 0 1 4 11.5v1A1.5 1.5 0 0 1 2.5 14h-1A1.5 1.5 0 0 1 0 12.5zm6 0A1.5 1.5 0 0 1 7.5 10h1a1.5 1.5 0 0 1 1.5 1.5v1A1.5 1.5 0 0 1 8.5 14h-1A1.5 1.5 0 0 1 6 12.5zm6 0a1.5 1.5 0 0 1 1.5-1.5h1a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1-1.5 1.5h-1a1.5 1.5 0 0 1-1.5-1.5z" />
                                </svg><span>Team</span></a></li>
                        <li><a href="{{ route('user_dashboard') }}">
                                <svg class="bi bi-person-circle" width="20" height="20" viewBox="0 0 16 16"
                                    fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M11 6a3 3 0 1 1-6 0 3 3 0 0 1 6 0" />
                                    <path fill-rule="evenodd"
                                        d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m8-7a7 7 0 0 0-5.468 11.37C3.242 11.226 4.805 10 8 10s4.757 1.225 5.468 2.37A7 7 0 0 0 8 1" />
                                </svg><span>Mine</span></a></li>
                    </ul>
                </div>

            </div>
        </div>
    @endif
    <!-- All JavaScript Files -->
    <script src="{{ url('public/template') }}/js/bootstrap.bundle.min.js"></script>
    <script src="{{ url('public/template') }}/js/slideToggle.min.js"></script>
    <script src="{{ url('public/template') }}/js/internet-status.js"></script>
    <script src="{{ url('public/template') }}/js/tiny-slider.js"></script>
    <script src="{{ url('public/template') }}/js/active.js"></script>
    <x-foot-inc />
</body>

</html>
