<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#0134d4">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <!-- The above 4 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <!-- Title -->
    <title>{{ $title }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com/">
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
        rel="stylesheet">
        <x-head-inc/>

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="{{ url('public/template') }}/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/bootstrap-icons.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/tiny-slider.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/baguetteBox.min.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/rangeslider.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/vanilla-dataTables.min.css">
    <link rel="stylesheet" href="{{ url('public/template') }}/css/apexcharts.css">
    <!-- Core Stylesheet -->
    <link rel="stylesheet" href="{{ url('public/template') }}/style.css">
    <!-- Web App Manifest -->
    <link rel="manifest" href="{{ url('public/template') }}/manifest.json">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
</head>

<body>
    <!-- Preloader -->
    <div id="preloader">
        <div class="spinner-grow text-primary" role="status"><span class="visually-hidden">Loading...</span></div>
    </div>
    <!-- Internet Connection Status -->
    <!-- # This code for showing internet connection status -->
    <div class="internet-connection-status" id="internetStatus"></div>

    <!-- Login Wrapper Area -->
    <div class="login-wrapper d-flex align-items-center justify-content-center">
        <div class="custom-container">
            <div class="text-center px-4 mb-3">
                <p><a href='{{ route('welcome') }}' class='btn btn-primary'><i class='bi bi-back'></i> Home</a></p>
                
                <a href='{{ route('welcome') }}'><img class="login-intro-img"
                    src="{{ url('public/images/'.config('settings.logo')) }}" alt=""></a></div>
                    <!-- Session Status -->
<x-auth-session-status :status="session('status')" />
<x-auth-errors :errors="$errors"/>
            {{ $slot }}

        </div>
    </div>
    <!-- All JavaScript Files -->
    <script src="{{ url('public/template') }}/js/bootstrap.bundle.min.js"></script>
    <script src="{{ url('public/template') }}/js/slideToggle.min.js"></script>
    <script src="{{ url('public/template') }}/js/internet-status.js"></script>
    <script src="{{ url('public/template') }}/js/tiny-slider.js"></script>
    <script src="{{ url('public/template') }}/js/baguetteBox.min.js"></script>
    <script src="{{ url('public/template') }}/js/countdown.js"></script>
    <script src="{{ url('public/template') }}/js/rangeslider.min.js"></script>
    <script src="{{ url('public/template') }}/js/vanilla-dataTables.min.js"></script>
    <script src="{{ url('public/template') }}/js/index.js"></script>
    <script src="{{ url('public/template') }}/js/imagesloaded.pkgd.min.js"></script>
    <script src="{{ url('public/template') }}/js/isotope.pkgd.min.js"></script>
    <script src="{{ url('public/template') }}/js/dark-rtl.js"></script>
    <script src="{{ url('public/template') }}/js/active.js"></script>
    <!-- PWA -->
    <script src="{{ url('public/template') }}/js/pwa.js"></script>
    <x-foot-inc/>
</body>

</html>
