<?php

use App\Models\TestimonyStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
Schema::create('testimony_statuses', function(Blueprint $table){
$table->id();
$table->string('name');
$table->timestamps();
});

TestimonyStatus::insert([
    ['name' => 'Approved'],
    ['name' => 'Disapproved'],
    ['name' => 'Pending'],
]);

        Schema::create('testimonies', function(Blueprint $table){
$table->id();
$table->foreignId('user_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
$table->string('url');
$table->foreignId('testimony_status_id')->default(3)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
$table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
