<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_banks', function(Blueprint $table){
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('bank_name');
            $table->string('acc_name');
            $table->string('acc_no');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
                    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
