<?php

use App\Models\WithdrawalStatus;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('withdrawal_statuses', function(Blueprint $table){
            $table->id();
            $table->string('name');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            });
            
            WithdrawalStatus::insert([
                ['name' => 'Processed'],
                ['name' => 'Rejected'],
                ['name' => 'Pending']
            ]);
            
                    Schema::create('withdrawals', function(Blueprint $table){
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('withdrawal_status_id')->default(3)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->double('amount');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
                    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
