<?php

use App\Models\InvestmentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investment_statuses', function(Blueprint $table){
$table->id();
$table->string('name');
$table->timestamp('created_at')->nullable();
$table->timestamp('updated_at')->nullable();
        });

        InvestmentStatus::insert([
            ['name' => 'Active'],
            ['name' => 'Inactive'],
            ['name' => 'Sold Out']
        ]);

        Schema::table('investments', function(Blueprint $table){
$table->longText('description')->nullable();
$table->foreignId('investment_status_id')->default(1)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
