<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function user_role()
    {
        return $this->belongsTo(UserRole::class);
    }
    public function transaction()
    {
        return $this->hasMany(Transaction::class);
    }
    public function ref()
    {
        return $this->belongsTo(User::class, 'ref_id', 'id');
    }
    public function ref_user()
    {
        return $this->hasMany(User::class, 'ref_id', 'id');
    }
    public function user_investment()
    {
        return $this->hasMany(UserInvestment::class);
    }
    public function pending_payment()
    {
        return $this->hasMany(PendingPayment::class);
    }
    public function withdrawal()
    {
        return $this->hasMany(Withdrawal::class);
    }
    public function user_bank()
    {
        return $this->hasOne(UserBank::class);
    }
    public function testimony()
    {
        return $this->hasMany(Testimony::class);
    }
    public function win()
    {
        return $this->hasMany(Win::class);
    }
    public function allowed_investments()    {
        return $this->hasMany(AllowedInvestment::class);
    }


}
