<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Slide;
use App\Exports\ExportUser;
use App\Models\PaymentBank;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\PaymentAmount;
use App\Models\PaymentGateway;
use App\Models\PendingPayment;
use App\Models\Withdrawal;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use App\Cryptomus;
use App\NowPayments;

class UserController extends Controller
{
    public function dashboard()
    {
        //user
        $user_count = User::where('user_role_id', 2)->count();
        //investmentsSum
        $investment_sum = Transaction::where('transaction_type_id', 2)->sum('amount');
        $slide_list = Slide::get();
        //latest transactions
        $transaction_list = Transaction::orderBy('created_at', 'desc')->limit(5)->get();
        $pending_payment_count = PendingPayment::where('type', 'bank')->where('pending_payment_status_id', 3)->count();
        $withdrawal_sum = Withdrawal::where('withdrawal_status_id', 1)->count();
        return view('dashboard', ['slide_list' => $slide_list, 'user_count' => $user_count, 'transaction_list' => $transaction_list, 'investment_sum' => $investment_sum, 'pending_payment_count' => $pending_payment_count, 'withdrawal_sum' => $withdrawal_sum]);
    }

    public function index($filter = '--', $type = '--')
    {
        $ft = filter($filter);
        $and = $ft['and'];
        $vfilter = $ft['vfilter'];

        $and = $and . " and user_role_id = 2 ";

        $list = User::whereRaw("id > 0 $and")->orderBy('created_at', 'desc')->paginate(20);
        if ($type == 'export') {
            return Excel::download(new ExportUser($list), 'user.xlsx');
        }

        return view('user.index', ['vfilter' => $vfilter, 'list' => $list, 'filter' => $filter]);
    }

    public function delete($id)
    {
        $table = User::find($id);
        $table->delete();

        return redirect()->route('user')->with('status', 'User deleted');
    }

    public function view($id)
    {
        $info = User::find($id);
        return view('user.view', ['info' => $info]);
    }

    public function recharge(Request $request)
    {
        /*$cryptomus = new Cryptomus();

        if ($request->has('continue')) {
            $request->validate([
                'network' => 'required'
            ]);

            return redirect()->route('recharge_confirm', ['request' => $request->input('network')]);
        }

        $payment_method = $cryptomus->payment_method();*/

        if($request->has('continue'))
        {
            //pending payment
        if(PendingPayment::where('user_id', Auth::id())->where('type', 'nowpayment')->where('pending_payment_status_id', 3)->count() > 0)
        {
        $table = PendingPayment::where('user_id', Auth::id())->where('type', 'nowpayment')->where('pending_payment_status_id', 3);
        $table->delete();
        }

        $orderId = uniqid('order_'); // Unique order ID

        $table = new PendingPayment();
        $table->amount = $request->input('amount');
        $table->user_id = Auth::id();
        $table->type = 'nowpayment';
        $table->order_id = $orderId;
        $table->save();

            $now_payment = new NowPayments();
            $payment = $now_payment->createPayment($request->input('amount'), $orderId);
            return redirect($payment['invoice_url']);
        }

        $payment_amount_list = PaymentAmount::orderBy('amount')->get();
        return view('user.recharge', ['payment_amount_list' => $payment_amount_list]);
    }

    public function recharge_confirm(Request $request, $req)
    {
        $net_arr = explode('|', $req);

        $network = $net_arr[0];
        $currency = $net_arr[1];
        $min_amount = $net_arr[2];
        $max_amount = $net_arr[3];
        $fee_amount = $net_arr[4];
        $percent = $net_arr[5];


        return view('user.recharge_confirm', ['network' => $network, 'currency' => $currency, 'min_amount' => $min_amount, 'max_amount' => $max_amount, 'req' => $req]);

        /*$payment_gateway_list = PaymentGateway::all();
        $payment_amount_info = PaymentAmount::find($id);
        $payment_bank = PaymentBank::inRandomOrder()->first();
        if ($request->has('btn_razorpay')) {
            $request->session()->put('razorpay_amount', $payment_amount_info->amount);
            return redirect()->route('razorpay_pay');
        }

        return view('user.recharge_confirm', ['payment_amount_info' => $payment_amount_info, 'payment_gateway_list' => $payment_gateway_list, 'payment_bank' => $payment_bank]);*/
    }

    public function recharge_confirmation($req)
    {
        $cryptomus = new Cryptomus();
        $net_arr = explode('|', $req);

        $network = $net_arr[0];
        $currency = $net_arr[1];
        $min_amount = $net_arr[2];
        $max_amount = $net_arr[3];
        $fee_amount = $net_arr[4];
        $percent = $net_arr[5];

        $order_id = ref();

        $result = $cryptomus->static_wallet($network, $currency, $order_id);
        //print_r($result);
        //exit;

        //pending payment
        if(PendingPayment::where('user_id', Auth::id())->where('type', 'cryptomus')->where('pending_payment_status_id', 3)->count() > 0)
        {
        $table = PendingPayment::where('user_id', Auth::id())->where('type', 'cryptomus')->where('pending_payment_status_id', 3);
        $table->delete();
        }

        $table = new PendingPayment();
        $table->amount = 0;
        $table->user_id = Auth::id();
        $table->type = 'cryptomus';
        $table->order_id = $order_id;
        $table->save();
        
        return redirect()->away($result['url']);
    }

    public function user_dashboard()
    {
        $transaction_list = Transaction::where('user_id', Auth::id())->orderBy('created_at', 'desc')->limit(5)->get();
        return view('user.user_dashboard', ['transaction_list' => $transaction_list]);
    }

    public function referrals()
    {
        $list = User::where('ref_id', Auth::id())->orderBy('created_at', 'desc')->paginate(20);

        return view('user.referrals', ['list' => $list]);
    }

    public function referrals2()
    {
        return view('user.referrals2');
    }

    public function transfer_fund(Request $request)
    {
        $request->validate([
            'amount' => 'required'
        ]);

        //transfer
        $table = User::find($request->input('id'));
        $table->wallet = $table->wallet + $request->input('amount');
        $table->save();
        //transaction
        $table = new Transaction();
        $table->user_id = $request->input('id');
        $table->transaction_type_id = 9;
        $table->description = "Admin transfer to user";
        $table->amount = $request->input('amount');
        $table->ref = ref();
        $table->save();

        return redirect()->back()->with('status', 'Transfer successfull');
    }
}
