<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Testimony;
use Illuminate\Http\Request;
use App\Models\TestimonyStatus;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;

class TestimonyController extends Controller
{
    public function index($type = '--', $filter = '--')
    {
        $my_id = Auth::id();
        $ft = filter($filter);
        $and = $ft['and'];
        $vfilter = $ft['vfilter'];

        if($type == 'pending')
        {
            $and = $and." and testimony_status_id = 3";
        }

        if (Auth::user()->user_role_id == 2) {
            $and = $and . " and user_id = $my_id ";
        }
        $testimony_status_list = TestimonyStatus::all();
        $list = Testimony::whereRaw("id > 0 $and")->orderBy('created_at', 'desc')->paginate(20);
        return view('testimony.index', ['list' => $list, 'vfilter' => $vfilter, 'testimony_status_list' => $testimony_status_list, 'type' => $type]);
    }

    public function create()
    {
        return view('testimony.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'url' => 'required'
        ]);

        $table = new Testimony();
        $table->url = $request->input('url');
        $table->user_id = Auth::id();
        $table->save();

        //mark testified
        $user_info = User::find(Auth::id());
        $user_info->testify = 0;
        $user_info->save();

        return redirect()->route('testimony')->with('status', 'Testimony submitted');
    }

    public function approve($id)
    {
        $info = Testimony::find($id);
        //credit user
        $user_info = $info->user;
        $user_info->wallet = $user_info->wallet + config('settings.testimony_bonus');
        $user_info->save();

        $info->testimony_status_id = 1;
        $info->save();

        //transaction
        $table = new Transaction();
        $table->user_id = $info->user_id;
        $table->transaction_type_id = 10;
        $table->description = "Bonus for Testifying";
        $table->amount = config('settings.testimony_bonus');
        $table->save();


        return redirect()->back()->with('status', 'Testimony Approved');
    }
    public function disapprove($id)
    {
        $info = Testimony::find($id);
        $info->testimony_status_id = 2;
        $info->save();

        //mark testified
        $user_info = $info->user;
        $user_info->testify = 1;
        $user_info->save();

        return redirect()->back()->with('status', 'Testimony Disapproved');
    }
}
