<?php

namespace App\Http\Controllers;

use App\Models\Slide;
use Illuminate\Http\Request;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;

class SlideController extends Controller
{
    public function index($filter = '--')
    {
        $list = Slide::orderBy('created_at', 'desc')->get();

        return view('slide.index', ['list' => $list]);
    }

    public function create($id = '--')
    {
        if ($id != '--') {
            $info = Slide::find($id);
        }
        return view('slide.create', ['info' => @$info, 'id' => $id]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'pix' => 'image'
        ]);
        if ($request->has('id')) {
            $table = Slide::find($request->input('id'));
        } else {
            $request->validate([
                'pix' => 'required'
            ]);
            $table = new Slide();
        }
        $table->title = $request->input('title');
        $table->sub_title = $request->input('sub_title');

        if ($request->hasFile('pix')) {
            if($request->has('id'))
            {
                @unlink('public/uploads/slide/'.$table->pix);
            }
            $pix = $request->file('pix')->store('', 'slide');
            $manager = new ImageManager(
                new Driver()
            );
            // open an image file
            $image = $manager->read(public_path('uploads/slide/' . $pix));
            $image->resize(1920, 1280);
            $image->save();
            $table->pix = $pix;
        }

        $table->save();

        return redirect()->route('slide')->with('status', 'Slide saved');
    }

    public function delete($id)
    {
        $table = Slide::find($id);
        @unlink('public/uploads/slide/' . $table->pix);
        $table->delete();

        return redirect()->route('slide')->with('status', 'Slide deleted');
    }
}
