<?php

namespace App\Http\Controllers;

use App\Models\PaymentBank;
use App\Models\PendingPayment;
use App\Models\PendingPaymentStatus;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PendingPaymentController extends Controller
{
    public function index($filter = '--')
    {
        $my_id = Auth::id();
        $ft = filter($filter);
        $and = $ft['and'];
        $vfilter = $ft['vfilter'];

        if (Auth::user()->user_role_id == 2) {
            $and = $and . " and user_id = $my_id ";
        }
        $pending_payment_status_list = PendingPaymentStatus::all();
        $list = PendingPayment::whereRaw("type = 'bank' $and")->orderBy('created_at', 'desc')->paginate(20);
        return view('pending_payment.index', ['list' => $list, 'vfilter' => $vfilter, 'pending_payment_status_list' => $pending_payment_status_list]);
    }

    public function create($pay_amount)
    {
        $payment_bank = PaymentBank::inRandomOrder()->first();
        return view('pending_payment.create', ['pay_amount' => $pay_amount, 'payment_bank' => $payment_bank]);
    }

    public function store(Request $request)
    {
        //check if exist
        $check = PendingPayment::where('user_id', Auth::id())->where('pending_payment_status_id', 3)->where('type', 'bank')->count();
        if ($check > 0) {
            return redirect()->back()->withErrors(["You have an existing pending payment. Wait till it's processed before initiating another request"]);
        }

        $table = new PendingPayment();
        $table->amount = $request->input('amount');
        $table->user_id = Auth::id();
        $table->type = 'bank';
        $table->payment_bank_id = $request->input('payment_bank');
        $table->proof = $request->file('proof')->store('', 'proof');
        $table->save();

        return redirect()->route('pending_payment')->with('status', 'Payment Uploaded');
    }

    public function delete($id)
    {
        $info = PendingPayment::find($id);
        if ($info->pending_payment_status_id == 3 && $info->user_id == Auth::id()) {
            delete_pending_payment_proof($info->proof);
            $info->delete();
        }
        return redirect()->route('pending_payment')->with('status', 'Payment deleted');
    }

    public function process(Request $request, $id)
    {
        //credit user
        $info = PendingPayment::find($id);

        verify_payment($request, 'bank', $info);

        $table = $info;
        $table->pending_payment_status_id = 1;
        $table->save();

        return redirect()->back()->with('status', 'Payment Processed');
    }
    public function reject(Request $request, $id)
    {
        $info = PendingPayment::find($id);

        $table = $info;
        $table->pending_payment_status_id = 2;
        $table->save();

        return redirect()->back()->with('status', 'Payment Rejected');
    }
}
