<?php

namespace App\Http\Controllers;

use App\Models\PaymentBank;
use Illuminate\Http\Request;

class PaymentBankController extends Controller
{
    public function index()
    {
        $list = PaymentBank::orderBy('bank')->get();
        return view('payment_bank.index', ['list' => $list]);
    }

    public function create($id = '--')
    {
        if ($id != '--') {
            $info = PaymentBank::find($id);
        }

        return view('payment_bank.create', ['id' => $id, 'info' => @$info]);
    }

    public function store(Request $request)
    {
        if (!$request->has('id')) {
            $table = new PaymentBank();
        } else {
            $table = PaymentBank::find($request->input('id'));
        }
        $table->bank = $request->input('bank');
        $table->acc_name = $request->input('acc_name');
        $table->acc_number = $request->input('acc_number');
        $table->save();

        return redirect()->route('payment_bank')->with('status', 'Bank saved');
    }

    public function delete($id)
    {
        $info = PaymentBank::find($id);
        $info->delete();

        return redirect()->route('payment_bank')->with('status', 'Bank deleted');
    }
}
