<?php

namespace App\Http\Controllers;

use App\Models\AllowedInvestment;
use App\Models\User;
use App\Models\Investment;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\InvestmentStatus;
use App\Models\UserInvestment;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;

class InvestmentController extends Controller
{
    public function index($filter = '--')
    {
        $ft = filter($filter);
        $and = $ft['and'];
        $vfilter = $ft['vfilter'];

        if (Auth::user()->user_role_id == 2) {
            $and = $and . " and investment_status_id <> 2 ";
        }
        $investment_status_list = InvestmentStatus::all();
        $list = Investment::whereRaw("id > 0 $and")->orderBy('price')->paginate(20);
        return view('investment.index', ['list' => $list, 'vfilter' => $vfilter, 'investment_status_list' => $investment_status_list]);
    }

    public function create($id = '--')
    {
        if ($id != '--') {
            $info = Investment::find($id);
        }

        $investment_status_list = InvestmentStatus::all();

        return view('investment.create', ['id' => $id, 'info' => @$info, 'investment_status_list' => $investment_status_list]);
    }

    public function store(Request $request)
    {
        if (!$request->has('id')) {
            /*$request->validate([
                'pix' => 'image|required'
            ]);*/
            $table = new Investment();
        } else {
            $request->validate([
                'pix' => 'image|nullable'
            ]);
            $table = Investment::find($request->input('id'));
        }
        $table->name = $request->input('name');
        $table->price = $request->input('price');
        $table->duration = $request->input('duration');
        $table->daily_income = $request->input('daily_income');
        if ($request->hasFile('pix')) {
            if ($request->has('id')) {
                delete_investment_pix($table->pix);
            }
            $pix = $request->file('pix')->store('', 'investment');
            $manager = new ImageManager(
                new Driver()
            );
            // open an image file
            $img = $manager->read(public_path('uploads/investment/' . $pix));
            $img->resize(200, 200);
            $img->save();
            $table->pix = $pix;
        }
        $table->description = $request->input('description');
        $table->investment_status_id = $request->input('investment_status');
        $table->investment_allowed = $request->input('investment_allowed') ?? 0;
        $table->save();

        return redirect()->route('investment')->with('status', 'Investment saved');
    }

    public function delete($id)
    {
        $info = Investment::find($id);
        delete_investment_pix($info->pix);
        $info->delete();

        return redirect()->route('investment')->with('status', 'Investment deleted');
    }

    public function buy($id)
    {
        $info = Investment::find($id);
        if ($info->investment_status_id != 1) {
            return redirect()->back()->withErrors(['Investment not active']);
        }
        if (Auth::user()->wallet < $info->price) {
            $recharge_link = route('recharge');
            return redirect()->back()->withErrors(["Insufficient funds to invest. <a href='$recharge_link' class='btn btn-success'>Top up</a>"]);
        }

        //allowed investment
        if($info->investment_allowed > 0)
        {
            //check count
            $investment_count = AllowedInvestment::where('user_id', Auth::id())->where('investment_id', $id)->count();
            if($investment_count >= $info->investment_allowed)
            {
                return redirect()->back()->withErrors(['You have exceeded the number of times you can invest on this product']);
            }
            else
            {
                $table = new AllowedInvestment();
                $table->user_id = Auth::id();
                $table->investment_id = $id;
                $table->save();
            }
        }

        //deduct
        $table = User::find(Auth::id());
        $table->wallet = $table->wallet - $info->price;
        //allow testify
        $table->testify = 1;
        $table->save();
        //transaction
        $table = new Transaction();
        $table->user_id = Auth::id();
        $table->transaction_type_id = 2;
        $table->description = "Invested in {$info->name}";
        $table->amount = $info->price;
        $table->save();

        $tf_hour = 86400;
        $next_payment_date = date('Y-m-d H:i:s', time() + $tf_hour);
        //UserInvestment
        $table = new UserInvestment();
        $table->user_id = Auth::id();
        $table->investment_id = $id;
        $table->user_investment_status_id = 1;
        $table->remaining_days = $info->duration;
        $table->next_payment_date = $next_payment_date;
        $table->save();

        //check ref
        if (Auth::user()->ref_id != '' && Auth::user()->bonus_given == 0) {
            $bonus = (config('settings.referral_bonus') * $info->price) / 100;
            $table = User::find(Auth::user()->ref_id);
            $table->withdraw_wallet = $table->withdraw_wallet + $bonus;
            $table->save();
            //transaction
            $my_name = Auth::user()->name;
            $table = new Transaction();
            $table->user_id = Auth::user()->ref_id;
            $table->transaction_type_id = 7;
            $table->description = "Referral bonus from {$my_name}";
            $table->amount = $bonus;
            $table->save();
            //bonus_given
            $table = User::find(Auth::id());
            $table->bonus_given = 1;
            $table->save();

        }

        return redirect()->route('user_investment')->with('status', 'Investment successful');
    }
}
