<?php

use App\Models\PendingPayment;
use App\Models\PendingPaymentStatus;
use App\Models\TestimonyStatus;
use App\Models\Transaction;
use App\Models\User;
use App\Models\UserInvestment;
use App\Models\WithdrawalStatus;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

function filter($filter)
{
    $data = [];
    $and = '';
    $vfilter = '';

    $exp = explode('--', $filter);
    foreach ($exp as $item) {
        $exp2 = explode('__', $item);
        if ($exp2[0] == 'search') {
            if (Route::currentRouteName() == 'product') {
                $and = $and . " and (name like '%$exp2[1]%' or description like '%$exp2[1]%' or sku like '%$exp2[1]%') ";
            } else {
                $and = $and . " and name like '%$exp2[1]%' ";
            }
            $vfilter = $vfilter . "<small class='text-danger'>Search: </small>$exp2[1] | ";
        }

        if($exp2[0] == 'status')
        {
            if(Route::currentRouteName() == 'pending_payment')
            {
                $status_info = PendingPaymentStatus::find($exp2[1]);
                $and = $and." and pending_payment_status_id = $exp2[1] ";
            }
            if(Route::currentRouteName() == 'withdrawal')
            {
                $status_info = WithdrawalStatus::find($exp2[1]);
                $and = $and." and withdrawal_status_id = $exp2[1] ";
            }
            if(Route::currentRouteName() == 'testimony')
            {
                $status_info = TestimonyStatus::find($exp2[1]);
                $and = $and." and testimony_status_id = $exp2[1] ";
            }
            $vfilter = $vfilter . "<small class='text-danger'>Status: </small>$status_info->name | "; 
        }

        if ($exp2[0] == 'drange') {
            $dexp = explode(' - ', $exp2[1]);
            $st = $dexp[0] . " 00:00:01";
            $et = $dexp[1] . " 23:59:59";
            $and = $and . " and created_at >= '$st' and created_at <= '$et' ";
            $vfilter = $vfilter . "<small class='text-danger'>Date Range: </small>" . $exp2[1] . ' | ';
        }
    }

    if ($vfilter != '') {
        $vfilter = substr($vfilter, 0, -3);
    }

    $data['and'] = $and;
    $data['vfilter'] = $vfilter;

    return $data;
}

function setEnv($key, $value)
{
    $value = '"' . $value . '"';
    $envFile = app()->environmentFilePath();
    $str = file_get_contents($envFile);
    $oldValue = env($key);
    $str = str_replace("{$key}={$oldValue}", "{$key}={$value}", $str);
    $str = str_replace($key . '=' . '"' . $oldValue . '"', "{$key}={$value}", $str);
    $fp = fopen($envFile, 'w');
    fwrite($fp, $str);
    fclose($fp);
    /*echo $key.'='.$oldValue;
    exit;*/
}

function status($table, $info)
{
    if ($table == 'payment_gateways') {
        if ($info->status == 'Enabled') {
            $status_name = 'Enabled';
            $status_id = 1;
        } elseif ($info->status == 'Disabled') {
            $status_name = 'Disabled';
            $status_id = 2;
        }
    }

    if($table == 'user_investments')
    {
        $status_id = $info->user_investment_status_id;
        $status_name = $info->user_investment_status->name;
    }
    if($table == 'pending_payments')
    {
        $status_id = $info->pending_payment_status_id;
        $status_name = $info->pending_payment_status->name;
    }
    if($table == 'withdrawals')
    {
        $status_id = $info->withdrawal_status_id;
        $status_name = $info->withdrawal_status->name;
    }
    if($table == 'testimonies')
    {
        $status_id = $info->testimony_status_id;
        $status_name = $info->testimony_status->name;
    }

    switch ($status_id) {
        case 1:
            $color = 'success';
            break;
        case 2:
            $color = 'danger';
            break;
        case 3:
            $color = 'warning';
            break;
        case 4:
            $color = 'info';
            break;
        case 5:
            $color = 'primary';
            break;
        case 6:
            $color = 'secondary';
            break;
        case 7:
            $color = 'dark';
            break;
    }

    $stat = "<span class='badge text-white bg-$color'>$status_name</span>";
    return $stat;
}

function ref()
{
    $ref = uniqid();
    return $ref;
}

function verify_payment($request, $type, $obj)
{
    if ($type == 'stripe') {
        $ref = $obj->data->object->id;
        $total = $obj->data->object->amount_total / 100;

        $user_id = $obj->data->object->client_reference_id;
        $purchase_info = PendingPayment::where('user_id', $user_id)->where('type', 'stripe')->first();

        $amount = $purchase_info->amount;
        $user = $purchase_info->user_id;
    }
    if ($type == 'paystack') {
        $ref = $obj->data->reference;
        $user_id = Auth::id();
        $total = $obj->data->amount / 100;
    }
    if ($type == 'razorpay') {
        $ref = $obj;
        $user_id = Auth::id();
        $total = $request->session()->get('razorpay_amount');
    }
    if ($type == 'bank') {
        $ref = ref();
        $total = $obj->amount;
        $user_id = $obj->user_id;
    }
    if($type == 'cryptomus')
    {
        $ref = $obj['order_id'];
        $total = $obj['amount'];
        $user_id = $obj['user_id'];
    }
    if($type == 'nowpayment')
    {
        $ref = $obj['order_id'];
        $total = $obj['amount'];
        $user_id = $obj['user_id'];
    }

    //top up
    $table = User::find($user_id);
    $table->wallet = $table->wallet + $total;
    $table->save();
    //transaction
    $table = new Transaction();
    $table->user_id = $user_id;
    $table->transaction_type_id = 1;
    $table->description = 'Wallet Recharged';
    $table->amount = $total;
    $table->ref = $ref;
    $table->channel = $type;
    $table->save();

}

function validate_captcha($captcha)
{
    //check captcha
    $data = array(
        "secret" => config('settings')->g_secret_key,
        "response" => "$captcha"
    );
    //echo $data_string;
    $ch = curl_init("https://www.google.com/recaptcha/api/siteverify");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $result = curl_exec($ch);
    $result = json_decode($result, true);
    //$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);   //get status code
    //echo curl_error($ch);
    //echo $status_code;
    //print_r($result);

    //return $result;
    if ($result['success'] == true) {
        return true;
    } else {
        return false;
    }
}

function delete_investment_pix($pix)
{
    @unlink('public/uploads/investment/'.$pix);
}
function delete_pending_payment_proof($proof)
{
    @unlink('public/uploads/proof/'.$proof);
}

function transactions()
{
    $name = array(
        "James", "Olivia", "Michael", "Emma", "William", "Ava", "Benjamin", "Sophia",
        "Lucas", "Isabella", "Henry", "Mia", "Alexander", "Amelia", "Ethan", "Harper",
        "Mason", "Evelyn", "Daniel", "Abigail", "Jacob", "Ella", "Matthew", "Grace",
        "Samuel", "Chloe", "David", "Lily", "Joseph", "Aria", "Jackson", "Scarlett",
        "Sebastian", "Zoey", "Aiden", "Stella", "John", "Victoria", "Caleb", "Hannah",
        "Nathan", "Penelope", "Elijah", "Riley", "Joshua", "Leah", "Luke", "Hazel",
        "Ryan", "Ellie"
    );

    $transaction = array(
        5200, 7500, 8200, 9100, 6500, 10000, 5800, 6300,
        7200, 8400, 9900, 10500, 7600, 8800, 9400, 11500,
        5400, 8700, 6900, 6800, 9500, 8100, 8300, 9300,
        5700, 7700, 9200, 12000, 10800, 6600, 9400, 7100,
        7600, 8600, 9800, 10200, 6400, 8900, 9600, 11000,
        7400, 8500, 7200, 6700, 6900, 8600, 10000, 11900,
        9700, 10300, 300000, 500000, 1000000, 100000
    );

   $type = ['Wallet Topup','Investment','Withdrawal','Daily Bonus','Referral Bonus','Investment Profit'];

   $dis = '';
   for($i = 0; $i < 50; $i++)
   {
$name_rand = array_rand($name);
$xname = $name[$name_rand];
$transaction_rand = array_rand($transaction);
$xtransaction = config('settings.currency').number_format($transaction[$transaction_rand]);
$type_rand = array_rand($type);
$xtype = $type[$type_rand];

$dis = $dis."$xname $xtype $xtransaction | ";
   }

   if($dis != '')
   {
    $dis = substr($dis, 0, -3);
   }

   return $dis;

}

function investment_allowed($info)
{
    if($info->investment_allowed > 0)
    {
$allowed = $info->investment_allowed;
    }
    else
    {
$allowed = 'Multiple';
    }

    return $allowed;
}